 #include "mbed.h"
 #define FREQUENCY 125000


CAN can(PB_5, PB_6);


DigitalOut led1(PA_8);
DigitalOut led2(PA_9);

AnalogIn   ain(A0);

Thread sendThread(osPriorityAboveNormal, 2048);
Thread canrx;

CANMessage messageIn;
CANMessage messageOut;

int speed = 0;
int pose = 0;

void canRxIsr()
{
    while(1)
    {
    if(can.read(messageIn))
     {
      led1 = !led1;
      pose = messageIn.data[0] + (messageIn.data[1] << 8) + (messageIn.data[2] << 16) + (messageIn.data[3] << 24);
      printf("CAN: mess %d\n\r", pose);
      printf("CAN: id %x \n\r ",messageIn.id);
     }
     osDelay(10);
    }
}
   
void sendMessage()
{
   messageOut.data[0] = speed >> 24;
   messageOut.data[1] = speed >> 16;
   messageOut.data[2] = speed >> 8;
   messageOut.data[3] = speed;
   
   messageOut.id = 769;
    int status = can.write(messageOut);
    
    osDelay(1);
    
    messageOut.id = 771;
    status = can.write(messageOut);
    
    osDelay(1);
    
    speed = -speed;
    
    messageOut.data[0] = speed >> 24;
   messageOut.data[1] = speed >> 16;
   messageOut.data[2] = speed >> 8;
   messageOut.data[3] = speed;
    
    messageOut.id = (20 << 8) + 2;
    status = can.write(messageOut);
    
    osDelay(1);
    
    messageOut.id = 772;
    status = can.write(messageOut);
    
    
   printf("Send status: %d\r\n", status);
   if (status==1) led1 = !led1;
   osDelay(20);
}

void sendMessageLoop()
{
    while (true)
    {
        sendMessage();
       osDelay(1000);
    }
}

int main()
{
    int frequency = FREQUENCY;
    printf("CAN receive / transmit test. baudrate = %d \r\n", frequency);
    can.frequency(frequency);
    can.reset();
    //messageOut.id = 1200;
    messageOut.format = CANExtended;
   // messageOut.len = 0;

    //canrx.start(canRxIsr);
    sendThread.start(sendMessageLoop);
      printf("CAN INIT \r\n");

    while (true)
    {
        //speed = (int)((ain * 30000.0f) - 15000.0f);
        speed = 5000;
        
        //led1 = 0;
        osDelay(10);
    }
}          