//SCIENTIFIC CAN ID'S 201 TO 255

/***********
 Open box1  ||201|0|| can frame id 
 201 indirizzamento al sottosistema (scatole)
 202 indirizzamento dal sottosistema (scatole)
 203/4 indirizzamento dal sottosistema (envi)
 0  id scatola 1
 
 nel dato
 100 chiudi
 101 apri
 102 leggi


 CAN RX priorità piu bassa
 envi priorità normale
 box alta




Costruzione frame CAN
 void sci::buildFrame(struct can_frame &frame, uint8_t id, can_commands command, int32_t value)
{
 int len = 0;
 uint32_t new_id = id;
 new_id |= (uint32_t)command << 8;
 new_id |= 0x80000000;  100|0 0000 0000 0000 0  000 0000| 0000 0000
 frame.can_id = new_id;

 frame.data[len++] = value >> 24;
 frame.data[len++] = value >> 16;
 frame.data[len++] = value >> 8;
 frame.data[len++] = value;

 frame.can_dlc = len;
}
************/
#include "BOX.h"
#include "mbed.h"
#include "ENVIROMENTAL.h"

//EVENT FLAGS
#define OPEN_BOX  101
#define CLOSE_BOX 100
#define SEND_BOX_DATA_REQUEST 102

Thread can_rx_thd;
Thread box_thd;
Thread envi_thd;

EventFlags event_flags;

CAN can(PB_8, PB_9);
CANMessage msg;
CANFormat CANextended;

BOX box1(PA_9, PA_8, PB_0, PA_0, 1000, PA_4);
BOX box2(PC_9, PC_8, PB_1, PA_1, 1000, PA_5);
BOX box3(PC_7, PC_6, PB_2, PA_2, 1000, PA_6);
I2C i2c(PB_7,PB_6);
ENVIROMENTAL envi(PB_7, PB_6, PA_3, i2c);

unsigned char box_sel;
unsigned char box_cmd;

char message_out[8];
char envi_tx[8];
char data_box[3][8];

uint32_t new_id(int command, int id)
{
    uint32_t id_message = id;
    id_message |= (uint32_t)command << 8;
    id_message |= 0x80000000;

    return id_message;
}
void box()
{
    uint32_t flag_read = 0; 
    box1.initialize();
    box2.initialize(); 
    box3.initialize();
    int weight = 0;
    int resistence = 0;
    float temperature = 0;
    while(1)
    {
        flag_read = event_flags.wait_any(OPEN_BOX | CLOSE_BOX | SEND_BOX_DATA_REQUEST); //trigger this theand only if
        switch (flag_read)
        {
            case OPEN_BOX:
                switch(box_sel)
                {
                    case 1:
                        box1.move_servo(1000);
                        //open box 1
                        break;
                    case 2:
                        box2.move_servo(1000);
                        //open box 2
                        break;
                    case 3:
                        box3.move_servo(1000);
                        //open box 3
                        break;
                    default: break;
                }
                break;
            case CLOSE_BOX:
                switch(box_sel)
                {
                    case 1:
                        box2.move_servo(2200);
                        //close box 1
                        break;
                    case 2:
                        box2.move_servo(2200);
                        //close box 2
                        break;
                    case 3:
                        box2.move_servo(2200);
                        //close box 3
                        break;
                    default: break;
                }
                break;

            case SEND_BOX_DATA_REQUEST:
            //for every data request, a measure is made and then the data is sended on CAN
                switch(box_sel)
                {
                    case 1:
                        //make measurements box 1
                        weight = box1.get_weight();
                        resistence = box1.get_resistance();  //bisogna ancora "impacchettare i dati"
                        temperature = box1.get_temp();
                        //temperature 4 bytes
                        *(float*)(data_box[0]) = temperature;
                        //weight 2 bytes 
                        data_box[0][4] = (char)(weight >> 8);
                        data_box[0][5] = (char)(weight);
                        //resistence 2 bytes
                        data_box[0][6] = (char)(resistence >> 8);
                        data_box[0][7] = (char)(resistence);
                        break;
                    case 2:
                        //make measurements box 2
                        weight = box2.get_weight();
                        resistence = box2.get_resistance();
                        temperature = box2.get_temp();
                        //temperature 4 bytes
                        *(float*)(data_box[1]) = temperature;
                        //weight 2 bytes 
                        data_box[1][4] = (char)(weight >> 8);
                        data_box[1][5] = (char)(weight);
                        //resistence 2 bytes
                        data_box[1][6] = (char)(resistence >> 8);
                        data_box[1][7] = (char)(resistence);
                        break;
                    case 3:
                        //make measurements box 3
                        weight = box3.get_weight();
                        resistence = box3.get_resistance();
                        temperature = box3.get_temp();
                        //temperature 4 bytes
                        *(float*)(data_box[2]) = temperature;
                        //weight 2 bytes 
                        data_box[2][4] = (char)(weight >> 8);
                        data_box[2][5] = (char)(weight);
                        //resistence 2 bytes
                        data_box[2][6] = (char)(resistence >> 8);
                        data_box[2][7] = (char)(resistence);
                        break;
                    default: break;
                }
                for(int i=0; i<8; i++)
                {
                    message_out[i] = data_box[box_sel][i];
                }
                can.write(CANMessage(new_id(202, box_sel),message_out, 8));
                break;
            default: break;
        }
    }
}

void can_rx()
{
    while(1)
    {
        can.read(msg);

        switch (msg.id)
        {
            case 201:
                box_sel = msg.data[0];
                box_cmd = msg.data[1];
                event_flags.set(OPEN_BOX);
                break;
            case 202:
                box_sel = msg.data[0];
                box_cmd = msg.data[1];
                event_flags.set(CLOSE_BOX);
                break;
            case 203:
                box_sel = msg.data[0];
                event_flags.set(SEND_BOX_DATA_REQUEST);
                break;

        }
    }
}

void environmental() //make measurements and send to the can bus every second
{     
    float temp,CO;
    uint32_t hum;
    int32_t pres;
    int lumen, infrared, uv;

   temp = envi.get_temp();    //return temperature from SI7021
  hum = envi.get_humidity(); //return humidity from SI7021
  pres =  envi.get_pressure();    //return pressure in Pa from MBP280
  CO = envi.get_CO();  //return CO from  mq-7
  lumen =  envi.get_lumen();   //return visible lumen from TSL2561
  infrared = envi.get_infrared();   //return infrared lumen from TSL2561
  uv = envi.get_uv();    //return uv intensity from VEML6070
  
  envi_tx[1]=(char)(temp);
  envi_tx[2]=(char)(hum);
  envi_tx[3]=(char)(pres);
  envi_tx[4]=(char)(CO);
  envi_tx[5]=(char)(lumen);
  envi_tx[6]=(char)(infrared);
  envi_tx[7]=(char)(uv);  
  
    
    can.write(CANMessage(210, envi_tx, 8));
        osDelay(1000);
}


int main()
{ 
    can.frequency(125000);
    box_thd.start(mbed::callback(box));
    envi_thd.start(environmental);
    can_rx_thd.start(can_rx);
}


