#ifndef ENVIROMENTAL_H
#define ENVIROMENTAL_H
#include "TSL2561.h"
#include "mbed.h"
#include "BME280.h"     
#include "SI7021.h"
#include "VEML6070.h"


class ENVIROMENTAL
{
public:
  ENVIROMENTAL(PinName envi_SDA, PinName envi_SCL,PinName mq_analog,I2C &i2c);
  float get_temp();    //return temperature from SI7021
  uint32_t get_humidity(); //return humidity from SI7021
  int32_t get_pressure();    //return pressure in Pa from MBP280
  float get_CO();  //return CO from  mq-7
  int get_lumen();   //return visible lumen from TSL2561
  int get_infrared();   //return infrared lumen from TSL2561
  void calibrate_mq();   //run only once in clean air
  int get_uv();    //return uv intensity from VEML6070
  

virtual ~ENVIROMENTAL();



private:

PinName _pinSCL;
PinName  _pinSDA;
PinName  _mq_pin;
float  _tmp;
TSL2561 lux;
BME280 bmp;
SI7021 climate;
VEML6070 uv;

};

#endif
