#include "mbed.h"
#include "L6206.h"
#include "BDCMotor.h"

#define TX PC_10
#define RX PC_11


Serial SERIAL(D1, D0)

static volatile uint16_t gLastError;
static volatile uint8_t gStep = 0;

L6206_init_t init =
{
    L6206_CONF_PARAM_PARALLE_BRIDGES,                                                    
    {L6206_CONF_PARAM_FREQ_PWM1A, L6206_CONF_PARAM_FREQ_PWM2A, L6206_CONF_PARAM_FREQ_PWM1B, L6206_CONF_PARAM_FREQ_PWM2B},
    {100,100,100,100},
    {FORWARD,BACKWARD,FORWARD,BACKWARD},
    {INACTIVE,INACTIVE,INACTIVE,INACTIVE},
    {FALSE,FALSE}
};

//  Motor definition
L6206 *LinAct;
L6206 *EndEff;

int speed_elbow = 0;
int speed_ee = 0;

/*********************************/
/*      Interrupt Handlers       */
/*********************************/

//  Error Handler (called by the library when it reports an error)
void my_error_handler(uint16_t error)
{
  /* Backup error number */
  gLastError = error;
  
  /* Enter your own code here */
}

//  Flag Handler (overcurrent and thermal alarms reporting)
void my_flag_irq_handler(void)
{
    /* Get the state of bridge A */
    uint16_t bridgeState  = EndEff->get_bridge_status(0);

    if (bridgeState == 0) 
    {
        if ((EndEff->get_device_state(0) != INACTIVE)||
            (EndEff->get_device_state(1) != INACTIVE)) 
        {
            /* Bridge A was disabling due to overcurrent or over temperature */
            /* When at least on of its  motor was running */
            my_error_handler(0XBAD0);
        }
    }
  
    /* Get the state of bridge B */
    bridgeState  = LinAct->get_bridge_status(1);
  
    if (bridgeState == 0)  
    {
        if ((LinAct->get_device_state(2) != INACTIVE)||
            (LinAct->get_device_state(3) != INACTIVE)) 
        {
            /* Bridge A was disabling due to overcurrent or over temperature */
            /* When at least on of its  motor was running */
            my_error_handler(0XBAD1);
        }
    }  
}

/*****************************************************************************/

void rx()
{
        
}

/*****************************/
/*            MAIN           */
/*****************************/

int main()
{

//  Motor Initialization   
#ifdef TARGET_STM32F429
    LinAct = new L6206(PB_14, PB_15, PA_8, PA_9, PC_6, PC_7);     // EN_A, EN_B, IN1_A, IN2_A, IN1_B, IN2_B
    EndEff = new L6206(PB_14, PB_15, PA_8, PA_9, PC_6, PC_7);     // EN_A, EN_B, IN1_A, IN2_A, IN1_B, IN2_B
#else
    //LinAct = new L6206(PB_14, PB_15, PA_8, PA_9, PC_6, PC_7);
    LinAct = new L6206(D2, A4, D5, D4, A0, A1);
    EndEff = new L6206(D2, A4, D5, D4, A0, A1);
#endif

    if (LinAct->init(&init) != COMPONENT_OK) 
    {
        printf("ERROR: vvMotor Init\n\r");
        exit(EXIT_FAILURE);
    }
    if (EndEff->init(&init) != COMPONENT_OK) 
    {
        printf("ERROR: vvMotor Init\n\r");
        exit(EXIT_FAILURE);
    }
    
    LinAct->attach_flag_interrupt(my_flag_irq_handler);
    LinAct->attach_error_handler(my_error_handler);
    EndEff->attach_flag_interrupt(my_flag_irq_handler);
    EndEff->attach_error_handler(my_error_handler);
    printf("DONE: Motor Init\n\r");
    
    LinAct->set_dual_full_bridge_config(PARALLELING_NONE___1_BIDIR_MOTOR_BRIDGE_A__1_BIDIR_MOTOR_BRIDGE_B);
    EndEff->set_dual_full_bridge_config(PARALLELING_NONE___1_BIDIR_MOTOR_BRIDGE_A__1_BIDIR_MOTOR_BRIDGE_B);

    while(true)
    {            
        EndEff->set_speed(0, speed_ee);
        if(speed_ee < 0)
            EndEff->run(0, BDCMotor::BWD);
        else if(speed_ee > 0)
            EndEff->run(0, BDCMotor::FWD);
        else if(speed_ee == 0)
            EndEff->hard_stop(0);
            
        LinAct->set_speed(1, speed_elbow);
        if(speed_elbow < 0)
            LinAct->run(1, BDCMotor::BWD);
        else if(speed_elbow > 0)
            LinAct->run(1, BDCMotor::FWD);
        else if(speed_elbow == 0)
            LinAct->hard_stop(1);
          
        osDelay(100);
    }
}