#ifndef BOX_H
#define BOX_H

#include "mbed.h"
#include "HX711.h"
#include "DS1820.h"



class BOX
{ 
public:
  BOX (PinName pinCLK_HX711, PinName pinDAT_HX711,PinName pin_temp, PinName pin_cond,int HX711_coefficent,PinName pin_servo);
  float get_temp();    //return temperature from DS18B20
  int get_weight();    //return weight in g from hx711
  int get_resistance();//return voltage on resistor then :
                       //current = (1 - meas_v) / (2000000); kvl and V/R to get current
                       //resist = (meas_v / current);    Ohm law gives us the soil resistence 
  void move_servo(float ang);
  void tare(unsigned char times=20);         //sets tare on HX711 library
  void initialize();
  
  
  
virtual ~BOX();



private:

PinName _pinCLK;
PinName  _pinDAT;
PinName  _pintemp;
PinName _pincond;
int _coefficent;
float  _tmp;
DS1820 ds1820; // Dallas 1-wire
HX711 balance;
bool check;
PwmOut servo;

};

#endif