#include "BOX.h"

BOX::BOX (PinName pinCLK_HX711, PinName pinDAT_HX711, PinName pin_temp, PinName pin_cond, int HX711_coefficent, PinName pin_servo):ds1820(pin_temp),balance(pinDAT_HX711, pinCLK_HX711),servo(pin_servo)
{
  _pinCLK = pinCLK_HX711;
  _pinDAT = pinDAT_HX711;
  _pintemp = pin_temp;
  _pincond = pin_cond;
  _coefficent = HX711_coefficent;
  
  
}





BOX::~BOX(){}


void BOX::initialize(){
    
    check=ds1820.begin();
    servo.period(0.02f);
    balance.setTare(balance.averageValue(20));
    
    }

float BOX::get_temp()
{
  int result=0;
  float temp=0;
                    ds1820.startConversion();   // start temperature conversion from analog to digital
            wait(1.0);                  // let DS1820 complete the temperature conversion
            result = ds1820.read(temp); // read temperature from DS1820 and perform cyclic redundancy check (CRC)
            switch (result) {
                case 0:                 // no errors -> 'temp' contains the value of measured temperature
                  
                    break;

                case 1:                 // no sensor present -> 'temp' was not updated
                    printf("no sensor present\n\r");
                    break;

                case 2:                 // CRC error -> 'temp' was not updated
                    printf("CRC error\r\n");
                    
                default:
                break;
            

        }


return temp;
}



int BOX::get_resistance()
{
  AnalogIn cond_value(_pincond);                // reads voltage on the conductimeter pin.
 /* float meas_v;
  float current;*/
  float resistance;
  _tmp = 0;
  for(int i = 0; i < 20; i++)
  {
    resistance = cond_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
    /*current = (1 - meas_v) / (2000000); // kvl and V/R to get current
    _tmp = (meas_v / current);    // Ohm law gives us the soil resistence
    resistance = resistance + _tmp;*/
  }
  return (int) (resistance / 20);
}

void BOX::tare(unsigned char times)
{
  balance.setTare(balance.averageValue(times));
}

int BOX::get_weight()
{
  return (int) (balance.getGram() / _coefficent);
}
void BOX::move_servo(float ang)
{
    servo.pulsewidth(ang/1000000.0f);
}

