#include "mbed.h"
#include "L6208.h"

#define VREFA_PWM_PIN D3
#define VREFB_PWM_PIN D9
#define BAUDRATE 9600
#define JOINT 2
l6208_init_t init =
{
  8000,            //Acceleration rate in step/s^2 or (1/16)th step/s^2 for microstep modes
  80,              //Acceleration current torque in % (from 0 to 100)
  8000,            //Deceleration rate in step/s^2 or (1/16)th step/s^2 for microstep modes
  80,              //Deceleration current torque in % (from 0 to 100)
  8000,            //Running speed in step/s or (1/16)th step/s for microstep modes
  80,              //Running current torque in % (from 0 to 100)
  40,              //Holding current torque in % (from 0 to 100)
  STEP_MODE_1_16,  //Step mode via enum motorStepMode_t
  FAST_DECAY,      //Decay mode via enum motorDecayMode_t
  0,               //Dwelling time in ms
  FALSE,           //Automatic HIZ STOP
  100000           //VREFA and VREFB PWM frequency (Hz)
};


// Utility
//InterruptIn button(USER_BUTTON);
DigitalOut led(LED1);

// Motor Control
L6208 *motor;

InterruptIn end1(USER_BUTTON, PullUp);
DigitalIn end0(PA_5, PullUp);
Serial serial(PA_2, PA_3); 



float pose, current_pose;
float speed, current_speed;
void zero()
{
  printf("zero");
  motor->run(StepperMotor::BWD);
  while(!end0){
  }
  motor->hard_stop();
  motor->set_home();
  motor->go_to(0);
  printf("END0: Pressed\n\rPOSITION: %d\n\r", motor->get_position());
}

void motor_error_handler(uint16_t error)
{
  printf("ERROR: Motor Runtime\n\r");
  
}

void end1_int_handler()
{
  // motor->hard_stop();
  
  motor->run(StepperMotor::FWD);
  
  printf("END1: Pressed\n\rPOSITION: %d\n\r", motor->get_position());
}


void serialrx()
{

  int id, speed;
  
  
    if(serial.readable() ) 
    {
      serial.scanf("%d %d", &id, &speed );
      printf("%d %d\n", id, speed);
      if (id==JOINT)
      {
        led=!led;
        current_speed=speed;
      }
    
    
  }
}
  
  void fmotor()
  {
  
      
      if (current_speed>0)
      {
        printf("run FWD\n");
        motor->set_max_speed(abs(current_speed*80));
        motor->run(StepperMotor::BWD);
      }
      else if (current_speed<0)
      {
        printf("run BWD\n");
        motor->set_max_speed(abs(current_speed*80));
        motor->run(StepperMotor::FWD);
      }
      
      else
      {
        motor->hard_stop();
        current_pose= motor->get_position();
        motor->go_to(current_pose);
      }
      
      
      
    
  }
  
  
  /* Main ----------------------------------------------------------------------*/
  
  int main()
  {
    led=1;
    serial.baud(BAUDRATE);
    
    // Motor Initialization
    motor = new L6208(D2, D8, D7, D4, D5, D6, VREFA_PWM_PIN, VREFB_PWM_PIN);
    motor->set_step_mode(StepperMotor::STEP_MODE_1_16);
    if (motor->init(&init) != COMPONENT_OK)
    {
      printf("ERROR: vvMotor Init\n\r");
      exit(EXIT_FAILURE);
    }
    
    motor->attach_error_handler(&motor_error_handler);
    
    
   // end1.rise(&end1_int_handler);
    
    printf("DONE: Motor Init\n\r");
    
    
    printf("Running!\n\r");
    
    //zero();
    
    while(true)
    {
      serialrx();
      //wait (0.001);
      fmotor();
      
    }
  }