#include "mbed.h"

#define MOTOR_ENABLE_PIN D7
#define MOTOR_DIR_PIN D8

// Utility
InterruptIn button(USER_BUTTON, PullUp);
DigitalOut led(LED1);

// Motor Control
DigitalOut motor_enable(MOTOR_ENABLE_PIN);
DigitalOut motor_dir(MOTOR_DIR_PIN);

InterruptIn end0(PC_12, PullUp);
InterruptIn end1(PC_11, PullUp);
InterruptIn enc(PC_10, PullUp);

int current_pose = 0;
int pose = 0;

void motor_go_fwd()
{
    motor_enable = 1;
    motor_dir = 1;
    printf("gofwd\r\n");
}

void motor_go_bwd()
{
    motor_enable = 1;
    motor_dir = 0;
    printf("gobwd\r\n");
}

void motor_stop()
{
    motor_enable = 0;
    motor_dir = 0;
    printf("stop\r\n");
}

void motor_set_home()
{
    printf("END1: Released\n\r");
    motor_stop();
    
    current_pose = 0;
    pose = 0;
}

void button_int_handler()
{
    printf("BUTTON: Pressed\n\r");
    motor_go_fwd();
}

void end0_int_handler()
{
  motor_stop();
  printf("END0: Pressed\n\r");
  motor_go_fwd();
}

void end0_released()
{
  motor_stop();
  printf("END0: Released\n\r");
}

void end1_int_handler()
{
    motor_stop();
    printf("END1: Pressed\n\r");
    motor_go_bwd();
}

// CAN
Thread canrxa;

CAN can1(PB_5, PB_6);     // RX, TX

CANMessage messageIn;
CANMessage messageOut;


int filter = can1.filter(0x030, 0x4FF, CANStandard);

void canrx()
{
  while(1)
  {
    if(can1.read(messageIn, filter)&&messageIn.id==0x030)
    {
      pose = messageIn.data[0] + (messageIn.data[1] << 8) + (messageIn.data[2] << 16) + (messageIn.data[3] << 24);
      printf("CAN: mess %d\n\r", pose);
      printf("CANaacc: id %x \n\r ",messageIn.id);
      if (pose==0) motor_stop();
      else if (pose==1) motor_go_bwd(); 
      else if (pose==2) motor_go_fwd();
      
      //else motor_stop();
    }
    
    wait(0.05);
  }
}



/* Main ----------------------------------------------------------------------*/

int main()
{
  can1.frequency(125000);
  // Motor Initialization 
 // motor_stop();
  
  //end0.rise(&end0_int_handler);
  //end0.fall(&end0_released);
  //end1.rise(&end1_int_handler);
  //end1.fall(&motor_set_home);
  
  button.rise(&button_int_handler);
  
  printf("DONE: Motor Init\n\r");
  
  // CAN Initialization  
  canrxa.start(canrx);

  printf("DONE: CAN Init\n\r");
  
  
  printf("Running!\n\r");
  
 // motor_enable = 0;
 // motor_dir = 0;
  
  while(true)
  {
    wait(1000);
  }
}


