
/* Includes ------------------------------------------------------------------*/
/* mbed specific header files. */
#include "mbed.h"
/* Component specific header files. */
#include "L6208.h"
/* Definitions ---------------------------------------------------------------*/
#define VREFA_PWM_PIN D3
#define VREFB_PWM_PIN D9
/* Variables -----------------------------------------------------------------*/
/* Initialization parameters of the motor connected to the expansion board. */
l6208_init_t init =
{
  1500,            //Acceleration rate in step/s^2 or (1/16)th step/s^2 for microstep modes
  80,              //Acceleration current torque in % (from 0 to 100)
  1500,            //Deceleration rate in step/s^2 or (1/16)th step/s^2 for microstep modes
  80,              //Deceleration current torque in % (from 0 to 100)
  1000,            //Running speed in step/s or (1/16)th step/s for microstep modes
  80,              //Running current torque in % (from 0 to 100)
  40,              //Holding current torque in % (from 0 to 100)
  STEP_MODE_1_16,  //Step mode via enum motorStepMode_t
  FAST_DECAY,      //Decay mode via enum motorDecayMode_t
  0,               //Dwelling time in ms
  FALSE,           //Automatic HIZ STOP
  100000           //VREFA and VREFB PWM frequency (Hz)
};

/* Motor Control Component. */
L6208 *motor;
DigitalIn button (USER_BUTTON);
DigitalIn end(PC_10);
DigitalOut led(LED1);
/* Functions -----------------------------------------------------------------*/

/**
 * @brief  This is an example of user handler for the flag interrupt.
 * @param  None
 * @retval None
 * @note   If needed, implement it, and then attach and enable it:
 *           + motor->attach_flag_irq(&my_flag_irq_handler);
 *           + motor->enable_flag_irq();
 *         To disable it:
 *           + motor->DisbleFlagIRQ();
 */
void my_flag_irq_handler(void)
{
  printf("    WARNING: \"FLAG\" interrupt triggered:\r\n");
  motor->disable();
  printf("    Motor disabled.\r\n\n");
}

/**
 * @brief  This is an example of error handler.
 * @param[in] error Number of the error
 * @retval None
 * @note   If needed, implement it, and then attach it:
 *           + motor->attach_error_handler(&my_error_handler);
 */
void my_error_handler(uint16_t error)
{
  /* Printing to the console. */
  printf("Error %d detected\r\n\n", error);
  
  /* Infinite loop */
  while (true) {
  }    
}

/* Main ----------------------------------------------------------------------*/

int main()
{

//----- Initialization 
  /* Initializing Motor Control Component. */
  motor = new L6208(D2, D8, D7, D4, D5, D6, VREFA_PWM_PIN, VREFB_PWM_PIN);
  if (motor->init(&init) != COMPONENT_OK) {
    printf("error init\n\r");
    exit(EXIT_FAILURE);
  }

  /* Attaching and enabling an interrupt handler. */
  motor->attach_flag_irq(&my_flag_irq_handler);
  motor->enable_flag_irq();
    
  /* Attaching an error handler */
  motor->attach_error_handler(&my_error_handler);
 
  motor->set_step_mode(StepperMotor::STEP_MODE_1_8);

  /* Set speed, acceleration and deceleration to scale with microstep mode */
 //motor->set_max_speed(2000);
 //motor->set_acceleration(2400);
 //motor->set_deceleration(2400);
  motor->set_max_speed(motor->get_max_speed()<<2);
  motor->set_acceleration(motor->get_acceleration()<<2);
  motor->set_deceleration(motor->get_deceleration()<<2);
  printf(" init\n\r");
  end.mode(PullUp);
  /* Request to go position 9000 (quarter steps) */
   motor->run(StepperMotor::BWD);
  while(1)
    {
   //  motor->wait_while_active();
     printf("while");
      if(end) break;
    }
  motor->hard_stop(); 
  led=1;
  
  int pos=motor->get_position();
  printf("pos:%d\n\r", pos);
  motor->go_to(pos+200);
  motor->wait_while_active();
  led=0;
  wait(0.5);

  motor->set_home();
  wait(1);

  motor->go_to(1000<<4);
  motor->wait_while_active();
 
  while (true)
{
  motor->go_to(500<<4);
  motor->wait_while_active();
 
   motor->go_to(0);
   motor->wait_while_active();
   while (button)
  {
  
   }
}
    /* Waiting while the motor is active. */
    motor->wait_while_active();
  
    wait_ms(5000);  
  motor->disable();
}


