#include "mbed.h"
#include "FXOS8700Q.h"
//defines
#define DELAY 20    

//I2C lines for FXOS8700Q accelerometer
FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);


Serial pc(PTC15, PTC14);                //pins used in Bluetooth communication
//Serial pc(USBTX, USBRX);              //pins used in serial USB communication

DigitalIn sw2(SW2);
DigitalIn sw3(SW3);

void getAccValues();
void calculateTilt(float*,float*);
void sendDefault(int);
void sendJump(int);
void sendLeft(int);
void sendFastLeft(int);
void sendRight(int);
void sendFastRight(int);
void sendPause(int);
void sendDown(int);

float accX, accY, accZ;
bool sendingData = false;

int main()
{
    //sensor values
    float pitch, roll;
    
    //COUDL ADJUST BAUD RATE FOR UNITY
    pc.baud(9600);
    
    //enable the accelerometer
    acc.enable();      
     
        while (true)
        {
            getAccValues();
            calculateTilt(&pitch, &roll);
            
            //IF MOVING RIGHT
            if(roll > 0.6)
            {
                if(roll > 0.8)
                {
                    sendFastRight(DELAY);
                    sendingData = true;
                }
                else
                {
                    sendRight(DELAY);
                    sendingData = true;
                } 
            }
            
            //IF MOVING LEFT
            if(roll < -0.6)
            {
                if(roll < -0.8)
                {
                    sendFastLeft(DELAY);
                    sendingData = true;
                }
                else
                {
                    sendLeft(DELAY);
                    sendingData = true;  
                }
            }
            
            //IF DUCKING OR GOING DOWN PIPE
            if(pitch < -0.8)
            {
                sendDown(DELAY);
                sendingData = true;   
            }
            
            //IF JUMPING
            if(sw2 == 0)
            {
                sendJump(DELAY);
                sendingData = true;
            }
            
            if(sw3 == 0)
            {
                sendPause(DELAY);
                sendingData = true;   
            }
            
            //only send default value if we have no valid data to send
            if(sendingData == false)
            {
                sendDefault(DELAY);   
            }
            
            //done sending data
            sendingData = false;
            
            
            //remember multiple if statements can happen each loop and contribute thier own delay so in the worse case 
            //we delay number of actions * DELAY otherwise we send default case and delay for default time
            //there is also a slight delay in calculating pitch/roll and getting accel values
            
        }//end while
}//end main

void getAccValues()
{
    //read x y z from the accelerometer
    acc.getX(&accX);       
    acc.getY(&accY);
    acc.getZ(&accZ); 
}

void calculateTilt(float* pitch, float* roll)
{
    //calculate pitch and roll
    *pitch = atan2(accY,(sqrt(pow(accX, 2) + pow(accZ, 2 ))));
    *roll = atan2((-1 * accX),accZ);    
}

void sendDefault(int delay)
{
    pc.printf("%d",0);
    wait_ms(delay);
}

void sendJump(int delay)
{
    pc.printf("%d", 1);
    wait_ms(delay); 
}    

void sendLeft(int delay)
{
    pc.printf("%d",3);
    wait_ms(delay);
}

void sendRight(int delay)
{
    pc.printf("%d",4);
    wait_ms(delay);
}
void sendFastRight(int delay)
{
    pc.printf("%d",5);
    wait_ms(delay);
}
void sendFastLeft(int delay)
{
    pc.printf("%d",6);
    wait_ms(delay);
}
void sendPause(int delay)
{
    pc.printf("%d",7);
    wait_ms(delay);
}
void sendDown(int delay)
{
    pc.printf("%d",8);
    wait_ms(delay);
}