#include "mbed.h"
#include <cmath>

DigitalOut myled(LED1);

// 18 Digitial In pins for monitoring system
// 16 are low when ok, high when fault
// 2 that aren't are brake and current, low when fault, high when ok
DigitalIn interlock_in(p5);  // LOW OK, HIGH FAULT
DigitalIn tsms_in(p6);       // LOW OK, HIGH FAULT
DigitalIn inertia_in(p7);    // LOW OK, HIGH FAULT
DigitalIn bspd_latch_in(p8); // LOW OK, HIGH FAULT
DigitalIn pcb_in(p11);       // LOW OK, HIGH FAULT
DigitalIn hvd_in(p12);       // LOW OK, HIGH FAULT
DigitalIn e_stp_roll_in(p13);// LOW OK, HIGH FAULT
DigitalIn e_stp_dash_in(p14);// LOW OK, HIGH FAULT
DigitalIn ecu_in(p15);       // LOW OK, HIGH FAULT
DigitalIn imd_latch_in(p16); // LOW OK, HIGH FAULT
DigitalIn bspd_in(p18);      // LOW OK, HIGH FAULT
DigitalIn bms_in(p19);       // LOW OK, HIGH FAULT
DigitalIn fuse_in(p20);      // LOW OK, HIGH FAULT
DigitalIn imd_in(p21);       // LOW OK, HIGH FAULT
DigitalIn bms_latch_in(p23); // LOW OK, HIGH FAULT
DigitalIn bots_in(p24);      // LOW OK, HIGH FAULT

DigitalIn current_in(p17);   // HIGH OK, LOW FAULT
DigitalIn brake_in(p22);     // HIGH OK, LOW FAULT

CAN can1(p9,p10); // CAN bus
CANMessage shutdown_msg;

int main() {
    while(1) {
        int car_shutdown = 0;
        int latched_shutdown = 0;
        int any_fault = 0;
        
        // fault array
        int fault_array1[8] = {car_shutdown, latched_shutdown, any_fault, fuse_in, pcb_in, bots_in, e_stp_dash_in, inertia_in};
        //printf("Fault array: %d %d %d %d %d %d %d %d\r\n",fault_array1[0],fault_array1[1],fault_array1[2],fault_array1[3],fault_array1[4],fault_array1[5],fault_array1[6],fault_array1[7]);
        int fault_array2[8] = {e_stp_roll_in, tsms_in, hvd_in, interlock_in, ecu_in, bms_in, imd_in, !brake_in};
        int fault_array3[5] = {!current_in, bspd_in, bms_latch_in, imd_latch_in, bspd_latch_in};
        
        // find the sum of the faults, find if a shutdown fault has gone, find if a latch has gone
        int fault_latch[3] = {bms_latch_in, imd_latch_in, bspd_latch_in};
        int fault_shutdown[13] = {fuse_in, pcb_in, bots_in, e_stp_dash_in, inertia_in, e_stp_roll_in, tsms_in, hvd_in, interlock_in, ecu_in, bms_latch_in, imd_latch_in, bspd_latch_in};
    
        // if any latched fault is detected then set flag high
        for(int i=0;i<3;i++) {
            latched_shutdown = latched_shutdown + fault_latch[i];
            if (latched_shutdown>0) {
                latched_shutdown = 1;
                fault_array1[1] = latched_shutdown;
            }
        }
        // if any shutdown fault is detected then set flag high
        for(int j=0;j<5;j++) {
            car_shutdown = car_shutdown + fault_shutdown[j];
            printf("car shutdown = %d\r\n",car_shutdown);
            if (car_shutdown>0) {
                car_shutdown = 1;
                fault_array1[0] = car_shutdown;
                break;
            }
        }
        printf("CAR SHUTDOWN %d\r\n",car_shutdown);
        // if any fault is deteched set flag high
        for (int l=0;l<3;l++) {
            for (int k=0;k<8;k++) {
                any_fault = any_fault + fault_array1[k];
                if (any_fault>0) {
                    any_fault = 1;
                    fault_array1[2] = any_fault;
                    break;
                }
            }
            for (int m=0;m<8;m++) {
                any_fault = any_fault + fault_array2[m];
                if (any_fault>0) {
                    any_fault = 1;
                    break;
                }
            }
            for (int n=0;n<5;n++) {
                any_fault = any_fault + fault_array3[n];
                if (any_fault>0) {
                    any_fault = 1;
                    break;
                }
            }
        }
        
        for (int k=3;k<8;k++) {
            any_fault = any_fault + fault_array1[k];
            if (any_fault>0) {
                any_fault = 1;
                fault_array1[2] = any_fault;
                break;
            }
        }
        printf("ANY FAULT %d\r\n",any_fault);
        
        int x = 2;
        int byte1 = 0;
        int byte2 = 0;
        int byte3 = 0;
        // Generate the CAN message
        for (int b=0;b<8;b++) {
            int power = pow((double)x,b);
            //printf("Current val = %d, b = %d \r\n",fault_array1[b], power); 
            byte1 = byte1 + (fault_array1[b]*pow((double)x,b));
            //printf("Byte 1 = %d\r\n",byte1);
            byte2 = byte2 + (fault_array2[b]*pow((double)x,b));
            byte3 = byte3 + (fault_array3[b]*pow((double)x,b));
        }
        
        shutdown_msg.id = 0x705;
        shutdown_msg.data[0] = byte1;
        shutdown_msg.data[1] = byte2;
        shutdown_msg.data[2] = byte3;
        
        printf("CAN Message, %X %X %X %X \r\n", shutdown_msg.id,shutdown_msg.data[0],shutdown_msg.data[1],shutdown_msg.data[2]);
        //printf("CAN Message, %X %X \r\n", shutdown_msg.id,shutdown_msg.data[0]);
        
        wait(1);
    }
}
