// TBRe-AI FRONT MBED
// MONITORS STEERING ANGLE AND WHEEL SPEED
// AND SENDS THEM OVER CAN BUS
// WRITTEN BY SEB HALL ON 29/06/2022

#include "mbed.h"

const PinName writePin = p29;
const PinName readPin = p30;
const int busFrequency = 500000;
const unsigned int steeringMessageID = 100;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX);
AnalogIn steeringIn(p15);

union {
    double formattedData;
    unsigned char rawData[8]; 
} CANFormatted;

CAN CANBus(readPin, writePin, busFrequency);

void sendCANMessage(double data, unsigned int id) {
    
    CANMessage message;
    
    CANFormatted.formattedData = data;
    
    for (int i = 0; i < 8; i++) {
        message.data[i] = CANFormatted.rawData[i];
    }
    
    message.id = id;
    
    CANBus.write(message);
    
}

int main() {
    pc.printf("FRONT STARTED\n");
    led1 = !led1;
    while(1) {
        float num = (float) steeringIn.read();
        sendCANMessage(num, steeringMessageID);
        led1 = !led1;
        led2 = !led2;
    }
}