#include "mbed.h"
#include "mlx90614.h"

DigitalOut myled(LED1),p31(P0_29),p32(P0_30),laser_mod(p21); //displays I2C wait
DigitalIn tog_temp(p19),tog_gyro(p20);
I2C i2c(p9,p10);   //sda,scl
Serial pc(USBTX,USBRX);  //serial usb config
 
MLX90614 IR_thermometer(&i2c);
//setup an MLX90614 using MLX90614 library from
// http://mbed.org/users/aquahika/libraries/MLX90614/lsixz6
 
float temp; //temperature in degrees C
 
int main() {
    p31 = 0;
    p32 = 1;
    while (1) {
        if(tog_temp){
            p31 = 0;
            p32 = 1;
        }
        else if(tog_gyro){
            p31 = 1;
            p32 = 0; 
        }
        
        myled=1; // if led1 on - waiting on I2C
        if(p32 == 1){
            
            if (IR_thermometer.getTemp(&temp)) {
                //gets temperature from sensor via I2C bus
                myled=0;
                //print temperature on PC
                printf("Temperature is %5.1F degrees C\r\n",temp);
            }
        }else{
             printf("Gyro");
        }
        //wait for device to produce next temperature reading
        wait(0.5);
    }
}