#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
 
Serial pc(USBTX, USBRX);
static const char*          mbedIp       = "192.168.0.180";  //IP
static const char*          mbedMask     = "255.255.255.0";  // Mask
static const char*          mbedGateway  = "192.168.0.1";    //Gateway
 
int main() 
{
    char recv[30];
 
    EthernetInterface eth;
    pc.printf("mbed connected : %d\r\n", eth.init(mbedIp, mbedMask, mbedGateway));
    eth.connect();
    pc.printf("IP Address is %s\r\n", eth.getIPAddress());
 
    Websocket ws("ws://169.254.55.70:8080/");
    pc.printf("mbed connected to server : %d\r\n", ws.connect());
 
    while (1) 
    {
        ws.send("WebSocket Hello World over Ethernet");
        wait(1.0);
    }
}