#include "mbed.h"
#include "rtos.h"
#include <limits.h>

#define WHEEL_DIAM 52 // mm
#define WHEEL_CIRCUM  WHEEL_DIAM * 3.1415926535 //mm
#define RING_BUF_SZ 4

void addToRingBuf(int val, volatile int *ringBuf, volatile int *ringBufIdx);

void tach_mark(volatile int *ringBuf, volatile int *ringBufIdx, InterruptIn *Tach, 
                Timer *TachTimer, volatile bool *new_tach_flag, void (*tach_antimark_handler)(void)); 
                      
void tach_antimark(InterruptIn *Tach, void (*tach_mark_handler)(void));

void tach_count(void const *args);

float get_speed(volatile bool *new_tach_flag, Timer *TachTimer, volatile int *ringBuf, volatile int *ringBufIdx);

void speed_control(volatile float target_spd, float actual_spd, float *iState, float iLimit, volatile float ki, 
                   volatile float kp, PwmOut *motor, DigitalOut *brake);