#include "mbed.h"
#include "rtos.h"
#include "telemetry-mbed.h"
#include "MODSERIAL.h"

#define NUM_PIX 128
#define SKIP 15
#define UPDATE_RATE 10 //ms

/** Linescan functions (Nicholas Gan)
 * to capture linescan frames and process them. 
  */

uint16_t read1Bit(AnalogIn cam, DigitalOut *camClk);

void startRead(DigitalOut *camSi, DigitalOut *camClk);

float processFn(uint16_t *array, int arraySz, int* exposure, 
                bool preferLeftLine, int *numLines);
                
float getLinePos(AnalogIn cam, 
                 DigitalOut *camSi, 
                 DigitalOut *camClk, 
                 int *exposure, 
                 bool preferLeft,
                 int *lineCt,
                 telemetry::NumericArray<uint16_t, NUM_PIX> &tele_linescan);
                 
extern MODSERIAL serial;