#include "mbed.h"

Ticker Tick_SalirDisplay;
Ticker Tick_Control_PWM;
Ticker Tick_Contador;             //Interrupciones 
InterruptIn Sensor(PTB3);           // Interrupcion externa
PwmOut PWM1(PTC10);
AnalogIn Control_Ancho(PTB11);

BusOut Segmentos(PTB9,PTA1,PTB23,PTD0,PTD1,PTD3,PTD2,PTC4); 
BusOut Comcat (PTA2,PTC2,PTC3,PTB2);

const unsigned short Numeros [10]= {0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x67}; 
const unsigned short Comun [4] = {1,2,4,8}; //Digitos para Comunes de displays D1-D4

void Separacion_digitos (int NRPM);
void Show_Display (void);
void Var_Vel (void);   
void Contar_Vueltas(void);
void Int_Contar(void);


    int NRPM=0;
    int x = 0;
    int Contador=0; 


short Digito[4] = {0,0,0,0};  

int main()
{   
    Comcat = 0x00;    //Apagar todo. 
    Segmentos = 0x00;
    Contador=0;
   
    
    Tick_SalirDisplay.attach(&Show_Display, 0.003);
    Tick_Control_PWM.attach(&Var_Vel, 0.05);
    Tick_Contador.attach(&Contar_Vueltas, 1.0);
    
    while(1)
    {
        }

    }

void Separacion_digitos (int NRPM)
{
    unsigned short D,C,UM;
    
    UM = Digito[3] = NRPM/1000;              // Millar
    C = Digito[2] = (NRPM-UM*1000)/100;      // Centenas
    D = Digito[1] = (NRPM-UM*1000-C*100)/10; // Decenas
    Digito[0] = (NRPM-UM*1000-C*100-D*10);   // Unidades
}

void Show_Display (void)
{
    Separacion_digitos (NRPM);
    Comcat = 0x00;  //Borrar comunes para engañar al ojo humano aparentando todos los displays estan prendidos
 
    if (x <= 3) 
    {
    Segmentos = Numeros[Digito[x]];
    Comcat = Comun[x] ; 
    x++;
    if (x == 4)
        x=0;   
    }
      
}

void Var_Vel (void)
{
    PWM1.period(0.020); 
    PWM1.write(Control_Ancho.read()); 
}
    
void Contar_Vueltas (void)
{
    NRPM=Contador*60;
    Contador=0;
    Sensor.rise(&Int_Contar);
}
    
    void Int_Contar(void)
{

    if (Contador < 1000)
    {
        Contador ++;
        }
    else 
    {
        Contador = 0;
        }    
}    