#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "note.h"

DigitalIn bottone1(p23);
DigitalOut ledR(p25);
DigitalOut ledG(p24);
DigitalOut ledB(p26);
Rtc_Ds1307 rtc( p9,p10 );
PwmOut piezo(p22);

Serial pc(USBTX, USBRX, "pc");

bool flag1=0;
int  ultimo_giorno=0;
int orario;
long long int c;


void suono(int frequenza, int beat);
void seriale(Rtc_Ds1307::Time_rtc time);

int main()
{
    Rtc_Ds1307::Time_rtc time= {};
    seriale(time);
    while(1) {
        if(ultimo_giorno!=time.date) {      //if ultimo giorno è oggi
            if(orario == time.hour) {       //if è l'ora della pappa
                ledB=1;
                suono(NOTE_B4,1);
                ultimo_giorno=time.date;
            } else if(bottone1 && time.hour==(orario-1) && time.min>=30) {    //30 min prima
                ledR=1;
                suono(NOTE_B4,1);
                ultimo_giorno=time.date;
            } else if(bottone1 && time.hour>orario) {       //l'ora è gia passata ma devo ancora prenderlo
                ledG=1;
                suono(NOTE_B4,1);
                ultimo_giorno=time.date;
            } else {
                if(bottone1) {      //l'ora deve ancora venire e premo bottone
                    ledR=1;
                    suono(NOTE_B4,1);
                    wait(1);
                    ledR=0;
                }
            }
        } else {      //gia fatto oggi e premo bottone
            if(bottone1) {
                ledR=1;
                suono(NOTE_B4,1);
            }
        }
    }//while(1)
}//main

void suono(int frequenza, int beat)
{
    piezo.period(1.0 / frequenza);
    piezo.write(0.5);
    wait(1.0 / beat);
    piezo.write(0);
    wait(0.05);
}



void seriale(Rtc_Ds1307::Time_rtc time)
{
    int c;


    pc.printf("**********************************\n");
    pc.printf("* Menu :                            *\n");
    pc.printf("* 1 - imposta ora orologio       *\n");
    pc.printf("* 2 - imposta ora pastiglia          *\n");
    pc.printf("* 3 - mostra settaggi           *\n");
    pc.scanf("%d", &c);

    switch(c) {
        case 1:
            pc.printf("Giorno (0..31)");
            pc.scanf("%d", &time.date);
            pc.printf("Mese (1..12)");
            pc.scanf("%d", &time.mon);
            pc.printf("Anno ");
            pc.scanf("%d", &time.year);
            pc.printf("Ore (0..23)");
            pc.scanf("%d", &time.hour);
            pc.printf("Minuti (0..59)");
            pc.scanf("%d", &time.min);
            pc.printf("Secondi (0..59)");
            pc.scanf("%d", &time.sec);
            break;
        case 2:
            pc.printf("Orario pastiglia");
            pc.scanf("%d", &orario);
            break;
        case 3:
            pc.printf("Ora sono le : %02d:%02d:%02d del %02d/%02d/%04d \n", time.hour, time.min, time.sec, time.mon, time.date, time.year);
            break;
    }
}
