#include "mbed.h"
#include "EC.h" //Encoderライブラリをインクルード
#include "SpeedController.h"    //SpeedControlライブラリをインクルード
#include "math.h"
#define RESOLUTION 600  //分解能

//#define TEST_DUTY 0.3   //動確用


Ec4multi EC_1(PA_8,PA_11,RESOLUTION);//618
Ec4multi EC_2(PB_5,PB_4,RESOLUTION);
SpeedControl motor_1(PA_10,PB_7,50,EC_1);
SpeedControl motor_2(PA_12,PB_6,50,EC_2);
PwmOut pump(PA_7);
AnalogIn a_in(PA_4);
AnalogIn b_in(PA_3);
AnalogIn c_in(PA_1);
AnalogIn d_in(PA_0);

Ticker motor_tick;  //角速度計算用ticker
Serial pc(USBTX,USBRX);

Timer timer;

int j=1990;
int k = 0;
double rotate_1=0,rotate_2=0;
double mt_out1=0,mt_out2=0;
double tire_fai_mm=88;//タイヤ径
double machine_width=83;//機体の横幅
double odm_x=0,odm_y=0,odm_theta=0;
double crb_x=0,crb_y=0;
double odm_righttire=0,odm_lefttire=0;
double d_theta=0;
double old_rightrad=0,old_leftrad=0,old_theta=0;
double turn_adj=1;
double res_adj=1;
const double pi=3.1415926535;
int pump_active=1;
bool sensor_ok=true;
void passfollowing(double start_x,double start_y,double tgt_x,double tgt_y,double tgt_theta);


void CalOmega()
{

    EC_1.calOmega();
    EC_2.calOmega();
    odm_righttire=tire_fai_mm*(EC_1.getRad()-old_rightrad)/2/res_adj;
    odm_lefttire=tire_fai_mm*(EC_2.getRad()-old_leftrad)/2;//÷2するのが正しいが切ると正しくなる()
    odm_theta+=(odm_righttire-odm_lefttire)/machine_width/turn_adj;
    d_theta=(odm_righttire-odm_lefttire)/machine_width;
    odm_x+=-(odm_righttire+odm_lefttire)*sin(odm_theta-d_theta/2)/2;
    odm_y+=(odm_righttire+odm_lefttire)*cos(odm_theta-d_theta/2)/2;
    //odm_x+=-(odm_righttire+odm_lefttire)*sin((odm_theta+old_theta)/2)/2;
    //odm_y+=(odm_righttire+odm_lefttire)*cos((odm_theta+old_theta)/2)/2;
    //odm_x+=-(odm_righttire+odm_lefttire)*(sin(odm_theta)*cos(d_theta)+cos(odm_theta)*sin(d_theta))/2;
    //odm_y+=(odm_righttire+odm_lefttire)*(cos(odm_theta)*cos(d_theta)+sin(odm_theta)*sin(d_theta))/2;

    if(rotate_1==0) motor_1.stop();
    else if(sensor_ok==false)motor_1.stop();
    else motor_1.Sc(rotate_1);
    if(rotate_2==0) motor_2.stop();
    else if(sensor_ok==false)motor_2.stop();
    else motor_2.Sc(rotate_2);

    old_rightrad=EC_1.getRad();
    old_leftrad=EC_2.getRad();
    old_theta=odm_theta;
    if(sensor_ok==true&&pump_active!=0) {
        j+=1;
        if(j>=2000) {
            pump=1;
        }
        if(j>=2070) {
            pump=0;
            j=0;
        } else {
            j+=pump_active;
        }
    } else {
        pump=0;
        j=0;
    }
    //printf("%d ",k%100);
    //printf("%f,%f/r/n",rotate_1,rotate_1);
}
double calcdif(double start_x,double start_y,double tgt_x,double tgt_y,double tgt_theta,int separation);
void sensor_run(int form_or_back,double max_speed);
void gogogo_straight(double start_x,double start_y,double tgt_x,double tgt_y,double tgt_theta,double max_speed);
void gogogogo_straight(double start_x,double start_y,double tgt_x,double tgt_y,double tgt_theta,double max_speed);
void turnAtThePoint( double start_theta, double tgt_theta, double max_speed);
void sensor_use_run(int LorR,double max_speed);


int main()
{
    //UserLoopSetting_can();


    motor_1.period_us(50);
    motor_2.period_us(50);
    pump.period_us(50);
    //motor_1.setEquation(0.0429,0,0.0429,0);    //求めたC,Dの値を設定
    //motor_2.setEquation(0.0369,0,0.0429,0);    //求めたC,Dの値を設定
    motor_1.setEquation(0.04,0.25,0.04,0.25);    //求めたC,Dの値を設定
    motor_2.setEquation(0.04,0.2,0.04,0.2);    //求めたC,Dの値を設定
    motor_1.setPDparam(0.25,0.01);  //PIDの係数を設定
    motor_2.setPDparam(0.25,0.01);  //PIDの係数を設定
    motor_1.setDutyLimit(0.95);
    motor_2.setDutyLimit(0.95);
    motor_tick.attach(&CalOmega,0.005);

    rotate_1=0;
    rotate_2=0;
//printf("gs,%.3lf,%.3lf,%.3lf ,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,z=%.3lf\r\n",EC_1.getOmega(),EC_1.getRad(),rotate_1,EC_2.getOmega(),EC_2.getRad(),rotate_2,odm_x,odm_y,odm_theta*180/pi);

    wait(1);
//printf("gs,%.3lf %.3lf %.3lf ,%.3lf %.3lf %.3lf,%.3lf,%.3lf,z=%.3lf\r\n",EC_1.getOmega(),EC_1.getRad(),rotate_1,EC_2.getOmega(),EC_2.getRad(),rotate_2,odm_x,odm_y,odm_theta*180/pi);
    /*
    turnAtThePoint(0,-90,3);//起点終点速度
    turnAtThePoint(-90,90,3);//起点終点速度
    turnAtThePoint(90,-180,3);//起点終点速度
    turnAtThePoint(-180,180,3);//起点終点速度
    turnAtThePoint(180,0,3);//起点終点速度*/
    //sensor_run(0,1);//前後,最高速
    //odm_theta=0;
    //gogogogo_straight(10,0,10,-1000,1,5);
    //turnAtThePoint(0,-180,4);
    //gogogogo_straight(20,-1000,20,0,1,5);
    //odm_theta=0;
    //gogogo_straight(0,1000,0,0,1,10);
///////////////////////////////////////////////////real_use_setting/////////////////////////////////////////////////////////////
//////////////////////////////////////////////////キャリブレーション走行////////////////////////////////////////////////////////////
/////////////////////////////////turn_adjは脳筋回転角補正、crb_xは機体の座標系を現実に押しつけ//////////////////////////////////////////
/*    sensor_use_run(0,2);////////////1.決め打ち、まあ自由に走れよと
    res_adj=EC_1.getRad()/EC_2.getRad();
    odm_theta=0;
    wait(0.5);
    rotate_1=2,rotate_2=2;
    wait(0.3);
    rotate_1=0,rotate_2=0;
    wait(0.5);
    turnAtThePoint(0,75,4);
    sensor_use_run(0,2);////////////2.90°の精度出しをします
    wait(0.5);
    turn_adj=(odm_theta)/(pi/2);
    turn_adj=1.2;
    odm_theta=pi/2;
    crb_x=odm_x;
    crb_y=odm_y;
    rotate_1=2,rotate_2=2;
    wait(0.3);
    rotate_1=0,rotate_2=0;
    wait(0.5);
    turnAtThePoint(90,175,4);
    sensor_use_run(0,2);////////////3.
    wait(0.5);
    rotate_1=2,rotate_2=2;
    wait(0.3);
    rotate_1=0,rotate_2=0;
    wait(0.5);
    turnAtThePoint(180,265,4);
    sensor_use_run(0,2);/////////////4.3.とあわせてXY座標を出します、90°の精度出しもしたい
    wait(0.5);
    /////////////////////////////crb_x-=odm_x;
    /////////////////////////////crb_y-=odm_y;
    crb_x=650;
    crb_y=-1600;
    printf("x=%f,y=%f,turnadj=%f,resadj=%f,",crb_x,crb_y,turn_adj,res_adj);
    odm_x=0;
    odm_y=0;*/
//////////////////////////////////////////////////////////チートコード//////////////////////////////
    crb_x=650;
    crb_y=-1600;
    turn_adj=1.2;
    odm_theta=pi*3/2;    
//////////////////////////////////////////////////////////キャリブレーション走行ここまで////////////////////////////////////////////
    turnAtThePoint(270,225,4);
    gogogo_straight(0,0,75,-75,0,5);//↖後
    wait(0.5);
    turnAtThePoint(225,360,4);//
    sensor_run(0,1);//前後,最高速
    wait(0.5);
    //1行目
    odm_y=0,odm_theta=0;
    gogogogo_straight(75,0,75,crb_y+100,1,6);
    turnAtThePoint(odm_theta*180/pi,0,4);
    sensor_run(1,1);//前後,最高速
    int i=0,b=100;
    while(crb_x-100>odm_x) {
        //while(1) {
        turnAtThePoint(0,-45,4);
        gogogo_straight(b*i+75,crb_y,b*i+125,crb_y+50,0,5);
        wait(0.5);
        turnAtThePoint(-45,-180,4);
        sensor_run(0,1);//前後,最高速
        wait(0.5);
        odm_y=crb_y;
        gogogogo_straight(b*i+125,crb_y,b*i+125,-100,1,6);
        turnAtThePoint(odm_theta*180/pi,-180,4);
        sensor_run(1,1);//前後,最高速
        turnAtThePoint(-180,-135,4);
        gogogo_straight(b*i+125,0,b*i+175,-50,0,10);
        wait(0.5);
        turnAtThePoint(-135,0,4);
        sensor_run(0,1);//前後,最高速
        wait(0.5);
        odm_y=0;
        gogogogo_straight(b*i+175,0,b*i+175,crb_y+100,1,6);
        turnAtThePoint(odm_theta*180/pi,0,4);
        sensor_run(1,1);//前後,最高速
        i++;
    }

//gogogo_straight(0,0,0,1000,1,5);

    rotate_1=0;
    rotate_2=0;
    pump_active=0;
    wait(1);
    while(1) {
        //pump=1;
        printf("done");
        //rotate_1 = mt_out1;
        //rotate_2 = mt_out2;
        /*
                if(pc.readable()) {
                    char sel=pc.getc();
                    if(sel=='s') {
                        motor_1.stop();
                        motor_2.stop();
                        rotate_1=0;
                        rotate_2=0;
                    } else if(sel=='j') {
                        rotate_1+=1;        //eを押すとduty比がo.o2ずつあがる
                        pc.printf("tgt=%f\r\n",rotate_1);
                    } else if(sel=='u') {
                        rotate_2+=1;        //eを押すとduty比がo.o2ずつあがる
                        pc.printf("tgt=%f\r\n",rotate_2);
                    } else if(sel=='k') {
                        rotate_1-=1;        //dを押すとduty比がo.o2ずつさがる
                        pc.printf("tgt=%f\r\n",rotate_1);
                    } else if(sel=='i') {
                        rotate_2-=1;        //dを押すとduty比がo.o2ずつさがる
                        pc.printf("tgt=%f\r\n",rotate_2);
                        //else if(sel=='p'){
                        //   print=!print;                //pを押すと表示を停止/再開する
                        //}
                    }
                }
                if(k>10000) {
                    printf("%.3lf %.3lf %.3lf ,%.3lf %.3lf %.3lf////x=%.3lf,y=%.3lf,z=%.3lf\r\n",EC_1.getOmega(),EC_1.getRad(),rotate_1,EC_2.getOmega(),EC_2.getRad(),rotate_2,odm_x,odm_y,odm_theta*180/pi);
                    //printf("\nloop\n\n\r");
                    //printf("%.3lf,%.3lf",motor_1.Sc.duty,motor_2.Sc.duty);
                    k=0;
                }
                k++;
        */
        //printf("%d",k);
    }
    printf("finish\n\r");
}
double start()
{
    while(1) {

    }
}
bool goal=false;
double calcdif(double start_x,double start_y,double tgt_x,double tgt_y,double tgt_theta)
{
    goal=false;
    double Vector_ab[2] = {(tgt_x - start_x), (tgt_y - start_y)}; //ベクトルAB
    double ab_Vector_size = hypot(Vector_ab[0], Vector_ab[1]); //ベクトルABの大きさ（hypot(a,b)で√（a^2+b^2）を計算できる <math.h>））
    double UnitVector_ab[2] = {Vector_ab[0]/ab_Vector_size, Vector_ab[1]/ab_Vector_size}; //ベクトルABの単位ベクトル
    double UnitVector_ch[2] = {UnitVector_ab[1], -UnitVector_ab[0]}; //ベクトルCHの単位ベクトル
    double Vector_ac[2] = {(odm_x - start_x), (odm_y - start_y)}; //ベクトルAC
    double Vector_bc[2] = {(odm_x - tgt_x), (odm_y - tgt_y)}; //ベクトルBC
    double diff = UnitVector_ab[0]*Vector_ac[1] - UnitVector_ab[1]*Vector_ac[0]; //機体位置と直線ABの距離（外積を用いて計算）
    //printf("%f\r\n",Vector_ac[0]*Vector_bc[0]+Vector_ac[1]*Vector_bc[1]);
    if(Vector_ab[0]*Vector_bc[0]+Vector_ab[1]*Vector_bc[1]>0.1*ab_Vector_size) {
        goal=true;
    }
    return(diff);
}
void gogogo_straight(double start_x,double start_y,double tgt_x,double tgt_y,double f_or_b,double max_speed)
{
    motor_1.setEquation(0.04,0.5,0.04,0.5);    //求めたC,Dの値を設定
    motor_2.setEquation(0.04,0.4,0.04,0.4);    //求めたC,Dの値を設定
    motor_1.setPDparam(0.25,0.01);  //PIDの係数を設定
    motor_2.setPDparam(0.25,0.01);  //PIDの係数を設定
    double path_p=0.001,path_d=0;
    //path_p=0;
    //double angle_p=0.1,angle_d=0;
    double diff,diff_angle;
    Timer gggst_timer;
    gggst_timer.start();
    double tgt_theta=0;
    if(start_y<tgt_y) {
        tgt_theta=-180;
    }
    pump_active=max_speed/5+1;
    while(1) {
        if(k>1000) {
            printf("gs,%.3lf,%.3lf,%.3lf ,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,\r\n",EC_1.getOmega(),EC_1.getRad(),rotate_1,EC_2.getOmega(),EC_2.getRad(),rotate_2,odm_x,odm_y,odm_theta*180/pi,diff,diff_angle);
            //printf("\nloop\n\n\r");
            k=0;
        }
        k++;
        diff_angle=odm_theta*180/pi-tgt_theta;
        diff=calcdif(start_x,start_y,tgt_x,tgt_y,0);
        if(goal==true) {
            gggst_timer.stop();
            gggst_timer.reset();
            rotate_1=0;
            rotate_2=0;
            break;
        }//21

        if(f_or_b==0) {
            if(diff*diff_angle<0) {
                rotate_1=max_speed-path_p*(diff);
                rotate_2=max_speed+path_p*(diff);
            } else {
                rotate_1=max_speed-path_p*(diff);
                rotate_2=max_speed+path_p*(diff);
            }
        } else {
            if(tgt_theta==0) {
                //if(diff*diff_angle<0) {
                rotate_1=-max_speed+path_p*(diff);
                rotate_2=-max_speed-path_p*(diff);
                //} else {
                //    rotate_1=-max_speed-path_p*(diff)*2;
                //    rotate_2=-max_speed+path_p*(diff)*2;
                //}
            } else {
                //if(diff*diff_angle>0) {
                rotate_1=-max_speed+path_p*(diff);
                rotate_2=-max_speed-path_p*(diff);
                //} else {
                //    rotate_1=-max_speed+path_p*(diff)*2;
                //    rotate_2=-max_speed-path_p*(diff)*2;
                //}
            }
        }
        if(f_or_b==1) {
            if((float)c_in>=(float)0.95||(float)d_in>=(float)0.95) {
                sensor_ok=false;
            } else {
                sensor_ok=true;
            }
        }

    }
}
void turnAtThePoint(double start_theta, double tgt_theta, double max_speed)
{
    motor_1.setEquation(0.04,0.5,0.04,0.5);    //求めたC,Dの値を設定
    motor_2.setEquation(0.04,0.4,0.04,0.4);    //求めたC,Dの値を設定
    motor_1.setPDparam(0.3,0.01);  //PIDの係数を設定
    motor_2.setPDparam(0.3,0.01);  //PIDの係数を設定
    //double tgt_adj_theta=(tgt_theta-start_theta)*turn_adj+start_theta;
    double tgt_adj_theta=tgt_theta;
    pump_active=0;
    Timer tatp_timer;
    tatp_timer.start();
    while(1) {
        double speed=(tgt_adj_theta-odm_theta*180/pi)/20;
        if(speed<0) {
            speed=-speed;
        }
        if(speed>max_speed) {
            speed=max_speed;
        }
        if(odm_theta*180/pi>tgt_adj_theta) {
            rotate_1=-speed;
            rotate_2=speed;
        } else {
            rotate_1=speed;
            rotate_2=-speed;
        }
        //printf("tr,%.3lf,%.3lf,%.3lf ,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf\r\n",EC_1.getOmega(),EC_1.getRad(),rotate_1,EC_2.getOmega(),EC_2.getRad(),rotate_2,odm_x,odm_y,odm_theta*180/pi);
        //printf("%f,%f,%f,%f,\r\n",tgt_theta,odm_theta*180/pi,odm_x,odm_y);
        if(odm_theta*180/pi+1>tgt_adj_theta&&odm_theta*180/pi-1<tgt_adj_theta) {
            rotate_1=0;
            rotate_2=0;
            wait(0.5);
            if(odm_theta*180/pi+1>tgt_adj_theta&&odm_theta*180/pi-1<tgt_adj_theta) {
                pump_active=1;
                break;
            }
        }/*
        if((float)a_in>=(float)0.95||(float)b_in>=(float)0.95||(float)c_in>=(float)0.95||(float)d_in>=(float)0.95) {
            sensor_ok=false;
        } else {
            sensor_ok=true;
        }*/
    }
}
void sensor_run(int form_or_back,double max_speed)
{
    motor_1.setEquation(0.04,0.5,0.04,0.5);    //求めたC,Dの値を設定
    motor_2.setEquation(0.04,0.4,0.04,0.4);    //求めたC,Dの値を設定
    motor_1.setPDparam(0.25,0.01);  //PIDの係数を設定
    motor_2.setPDparam(0.25,0.01);  //PIDの係数を設定
    Timer gggst_timer;
    gggst_timer.start();
    while(1) {
        if(form_or_back==0) {
            if((float)a_in<=(float)0.95) {
                rotate_2=max_speed;
            } else {
                rotate_2=0;
            }
            if((float)b_in<=(float)0.95) {
                rotate_1=max_speed;
            } else {
                rotate_1=0;
            }
        } else {
            if((float)c_in<=(float)0.95) {
                rotate_1=-max_speed;
            } else {
                rotate_1=0;
            }
            if((float)d_in<=(float)0.95) {
                rotate_2=-max_speed;
            } else {
                rotate_2=0;
            }
        }
        if(k>10000) {
            //printf("gs,%.3lf,%.3lf,%.3lf ,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf\r\n",EC_1.getOmega(),EC_1.getRad(),rotate_1,EC_2.getOmega(),EC_2.getRad(),rotate_2,odm_x,odm_y,odm_theta*180/pi);
            ////////////////////////////////////////////printf("loop\n\r");
            ////////////////////////////////////////////printf("%f,%f,%f,%f,%lf,%lf",(float)a_in,(float)b_in,(float)c_in,(float)d_in,rotate_1,rotate_2);
            k=0;
        }
        k++;
        if(rotate_1==0&&rotate_2==0) {
            break;
        }//21
    }
}
void sensor_use_run(int LorR,double max_speed)
{
    motor_1.setEquation(0.04,0.5,0.04,0.5);    //求めたC,Dの値を設定
    motor_2.setEquation(0.04,0.4,0.04,0.4);    //求めたC,Dの値を設定
    motor_1.setPDparam(0.25,0.01);  //PIDの係数を設定
    motor_2.setPDparam(0.25,0.01);  //PIDの係数を設定
    while(1) {
        if(LorR==0) {//left//これしかつかわない
            if((float)d_in<=(float)0.95) {
                if((float)a_in<=(float)0.95) {
                    rotate_1=-max_speed;
                    rotate_2=-0.8*max_speed;
                } else {
                    rotate_1=-max_speed;
                    rotate_2=-0.6*max_speed;
                }
            } else {
                if((float)a_in<=(float)0.95) {
                    rotate_1=-0.4*max_speed;
                    rotate_2=-max_speed;
                } else {
                    rotate_1=-0.8*max_speed;
                    rotate_2=-max_speed;
                }
                if(c_in>(float)0.95&&d_in>(float)0.95) {
                    rotate_1=0;
                    rotate_2=0;

                    wait(0.1);
                    if(c_in<(float)0.95&&d_in<(float)0.95) {
                        rotate_1=-max_speed*0.4;
                        rotate_2=-max_speed*0.4;
                    }
                }
            }
        } else {//right
            if((float)a_in<=(float)0.95) {
                rotate_1=-max_speed*0.2;
                rotate_2=-max_speed;

            } else {
                rotate_1=-max_speed;
                rotate_2=-max_speed*0.8;
            }
            if(c_in>(float)0.95&&d_in>(float)0.95) {
                rotate_1=0;
                rotate_2=0;
                wait(0.1);
                if(c_in>(float)0.95&&d_in>(float)0.95) {
                    rotate_1=-max_speed*0.4;
                    rotate_2=-max_speed*0.4;
                }
                //res_adj=EC_1.getRad()/EC_2.getRad();

            }
        }
        if(k>10000) {
            printf("sur,%.3lf,%.3lf,%.3lf ,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf\r\n",EC_1.getOmega(),EC_1.getRad(),rotate_1,EC_2.getOmega(),EC_2.getRad(),rotate_2,odm_x,odm_y,odm_theta*180/pi);
            ////////////////////////////////////////////printf("loop\n\r");
            ////////////////////////////////////////////printf("%f,%f,%f,%f,%lf,%lf",(float)a_in,(float)b_in,(float)c_in,(float)d_in,rotate_1,rotate_2);
            k=0;
        }
        k++;
        if(rotate_1==0&&rotate_2==0) {
            break;
        }//21
    }
}
void gogogogo_straight(double start_x,double start_y,double tgt_x,double tgt_y,double f_or_b,double max_speed)
{
    //机長辺方向(つまりy軸上ムーブ)にしか使えないクソゴミカスプログラムです
//発表前日だからなゆるして(土下座)
    printf("a");
    motor_1.setEquation(0.04,0.5,0.04,0.5);    //求めたC,Dの値を設定
    motor_2.setEquation(0.04,0.4,0.04,0.4);    //求めたC,Dの値を設定
    motor_1.setPDparam(0.25,0.01);  //PIDの係数を設定
    motor_2.setPDparam(0.25,0.01);  //PIDの係数を設定
    double path_p=0.001,path_d=0;
    //path_p=0;
    //double angle_p=0.1,angle_d=0;
    double diff,diff_angle;
    double tgt_theta=0;
    pump_active=max_speed/5+1;
    printf("b");
    bool turn_done=true;
    while(1) {
        tgt_theta=atan((tgt_x-odm_x)/(tgt_y-odm_y));
        if(start_y<tgt_y){
            tgt_theta=tgt_theta-pi;
            }
        //if(k>1000) {
        printf("gs,%.3lf,%.3lf,%.3lf ,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,%.3lf,\r\n",EC_1.getOmega(),EC_1.getRad(),rotate_1,EC_2.getOmega(),EC_2.getRad(),rotate_2,odm_x,odm_y,odm_theta*180/pi,odm_x-tgt_x);
        //printf("\nloop\n\n\r");
        k=0;
        //}
        k++;
        

        if(odm_x>(tgt_x+10)||odm_x<(tgt_x-10)) {
            if(turn_done==false) {
                turnAtThePoint(odm_theta*180/pi,tgt_theta*180/pi,4);
                printf("tat\r\n");
                turn_done=true;
            }
        //} else {
            if(f_or_b==0) {
                rotate_1=max_speed;
                rotate_2=max_speed;
            } else {
                rotate_1=-max_speed;
                rotate_2=-max_speed;
                printf("gggs");
                wait(0.1);
            }
            if(odm_x>(tgt_x-10)&&odm_x<(tgt_x+10)) {
                turn_done=false;
            }
        }
        diff=calcdif(start_x,start_y,tgt_x,tgt_y,0);
        if(goal==true) {
            rotate_1=0;
            rotate_2=0;
            printf("g");
            break;
        }//21
        if(f_or_b==1) {
            if((float)c_in>=(float)0.95||(float)d_in>=(float)0.95) {
                sensor_ok=false;
            } else {
                sensor_ok=true;
            }
        }

    }
}