//Tuning dengan asumsi 4 data

#include "mbed.h"
#include "TextLCD.h"
#include <string>
#include "eeprom.h"

#define eeprom_SDA PC_9         //Pin SDA
#define eeprom_SCL PA_8         //Pin SCL
#define lcd_SDA PB_9            //Pin SDA
#define lcd_SCL PB_8            //Pin SCL
#define EEPROM_ADDR 0x0         //Address EEPROM

EEPROM eepromTuning (eeprom_SDA, eeprom_SCL, EEPROM_ADDR, EEPROM::T24C256);
I2C i2c_lcd(lcd_SDA, lcd_SCL);
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2);                              // I2C bus, PCF8574 Slaveaddress, LCD Type


//Variable
int32_t eepromData[5];           //Data yang disimpan di eepromTuning
int     tuningData[5];           //Data tuning
    
int buttonSelect;                //Select
int buttonUp;
int buttonDown;
int buttonData1;
int buttonData2;
int buttonData3;
int buttonData4;
int modeEdit;                    //Mode Edit

//Funtion and Procedure
void tuningBaca();
void tuningEdit();
void showLCDEdit();
void updateEEPROM();
void showLCD();

int main(){
    //eepromTuning.clear();     //Menghapus data EEPROM
    modeEdit=0;
    tuningBaca();
    while(1){
        tuningEdit();
    }
}

void tuningBaca(){
    int i;
    for(i=1;i<=4;i++){
        eepromTuning.read(i, tuningData[i]);
    }
}

void tuningEdit(){
    if(buttonSelect==1){
        modeEdit=!modeEdit;
        wait(0.2);
        if(modeEdit==0){
            int i;
            for(i=1;i<=4;i++){
                eepromData[i]=(int32_t) tuningData[i];
            }
            updateEEPROM();
        }
    }
    if (modeEdit==1){
        if(buttonData1==1 && buttonUp==1){
            tuningData[1]+=1;
            showLCDEdit();    
        }else if (buttonData1==1 && buttonDown==1){
            tuningData[1]-=1;
            showLCDEdit(); 
        }else if (buttonData2==1 && buttonUp==1){
            tuningData[2]+=1;
            showLCDEdit();    
        }else if (buttonData2==1 && buttonDown==1){
            tuningData[2]-=1;
            showLCDEdit();
        }else if (buttonData3==1 && buttonUp==1){
            tuningData[3]+=1;
            showLCDEdit();    
        }else if (buttonData3==1 && buttonDown==1){
            tuningData[3]-=1;
            showLCDEdit();
        }else if (buttonData4==1 && buttonUp==1){
            tuningData[4]+=1;
            showLCDEdit();    
        }else if (buttonData4==1 && buttonDown==1){
            tuningData[4]-=1;
            showLCDEdit();
        }
    }
}

void updateEEPROM(){
    int i;
    //eepromTuning.clear();
    for(i=1;i<=4;i++){
        eepromTuning.write(i, (int32_t) eepromData[i]);
    }
}
void showLCDEdit(){
    int i;
    for(i=1;i<=4;i++){
        lcd.locate(1,(2*i));
        lcd.printf("D");
        lcd.locate(1,(2*i+1));
        lcd.printf("%d",i);
        lcd.locate(2,(2*i));
        lcd.printf("%d", tuningData[i]);
    }        
} 

void showLCD(){
    int32_t lcdData[4];
    int i;
    for(i=1;i<=4;i++){
        eepromTuning.read(i, lcdData[i]);
        lcd.locate(1,(2*i));
        lcd.printf("%d", lcdData[i]);
    }
}