#include "mbed.h"
#include "JoystickPS3.h"
#include "eeprom.h"

#define eeprom_SDA PB_3          //Pin SDA
#define eeprom_SCL PB_10         //Pin SCL
#define EEPROM_ADDR 0x0          //Address EEPROM

Serial pc(USBTX, USBRX, 115200);
joysticknucleo stick(PA_0, PA_1);
EEPROM eepromTuning (eeprom_SDA, eeprom_SCL, EEPROM_ADDR, EEPROM::T24C256);


//Variable
int32_t eepromData[5];           //Data yang disimpan di eepromTuning
int     tuningData[5];           //Data tuning
int     modeEdit;

void tuningBaca();
void updateEEPROM();
void showPCEdit();
void showPC();

int main(){
    stick.setup();
    stick.idle();
    //eepromTuning.clear();     //Menghapus data EEPROM
    modeEdit=0;
    tuningBaca();
    while(1){
        if( (!stick.atas)&&(!stick.bawah)&&(!stick.kanan)&&(!stick.kiri)&&(!stick.L1)&&(!stick.R1)&&(!stick.R2)&&
            (!stick.lingkaran)&&(!stick.segitiga)&&(!stick.kotak)&&(stick.silang)){
            modeEdit=!modeEdit;
            wait(0.1);
            if(modeEdit==0){
                int i;
                for(i=1;i<=4;i++){
                    eepromData[i]=(int32_t) tuningData[i];
                }
                updateEEPROM();
            }
        }

        if(modeEdit==1){
            if(stick.readable() ) {
                stick.baca_data();
                stick.olah_data();
                if( (stick.atas)&&(!stick.bawah)&&(!stick.kanan)&&(!stick.kiri)&&(!stick.L1)&&(stick.R1)&&(!stick.R2)&&
                    (!stick.lingkaran)&&(!stick.segitiga)&&(!stick.kotak)&&(!stick.silang)){
                    tuningData[1]+=1;
                }
                if( (stick.atas)&&(!stick.bawah)&&(!stick.kanan)&&(!stick.kiri)&&(!stick.L1)&&(!stick.R1)&&(stick.R2)&&
                    (!stick.lingkaran)&&(!stick.segitiga)&&(!stick.kotak)&&(!stick.silang) ){
                    tuningData[1]-=1;
                }
            }
            showPCEdit(); 
        }
        if(modeEdit==0){
            showPC();
        }
    }
}



void tuningBaca(){
    int i;
    for(i=1;i<=4;i++){
        eepromTuning.read(i, tuningData[i]);
    }
}

void updateEEPROM(){
    int i;
    //eepromTuning.clear();
    for(i=1;i<=4;i++){
        eepromTuning.write(i, (int32_t) eepromData[i]);
    }
}

void showPCEdit(){
    pc.printf("Data Atas");
    pc.printf("     %d       \n", tuningData[1]);     
}

void showPC(){
    pc.printf("Data Atas");
    pc.printf("     %d       \n", eepromData[1]);     
} 