#include "mbed.h"
 
SPISlave device(PA_7, PA_6, PA_5, PA_4); // mosi, miso, sclk, ssel
 
Serial pc(USBTX, USBRX); // tx, rx
 
int main() {
    pc.baud(115200);
    int counter = 1;
 
    device.format(8,3);        // Setup:  bit data, high steady state clock, 2nd edge capture
    device.frequency(1000000); // 1MHz
 
    int reply = pc.getc()-48;
    device.reply(reply);              // Prime SPI with first reply
    device.reply(reply);              // Prime SPI with first reply, again
 
    pc.printf("======================================================\r\n");
    pc.printf("Startup Next reply will be %d\r\n", reply);
 
    while (1) {
        if (device.receive()) {
            int valueFromMaster = device.read();
            pc.printf("%d Something rxvd, and should have replied with %d\n\r", counter++, reply);
            device.reply(++reply);              // Prime SPI with next reply
            pc.printf("    Received value from Master (%d) Next reply will be %d \r\n", valueFromMaster, reply);
        }
    }
}