
#include "mbed.h"

// 3 digitalna in-a za botune
InterruptIn tipka1(D2);
InterruptIn tipka2(PC_3);
InterruptIn tipka3(PC_2);

// za generiranje nasumicnog broja
AnalogIn analog (A1);

// print u tera term
Serial pc(USBTX, USBRX);

// za pomoć pri programiranju
DigitalOut led1(LED1);
InterruptIn tester(PC_13);  // B1

// PWM za buzzer
PwmOut buzzer(PB_3);

// debounce timer za tipkala
Timer debounce;             

// 7 seg display bus i fja
BusOut Seg1(D5,D6,D7,D8,D9,D10,D11,D12);
char SegConvert(char SegValue);


// varijable
int r = 4;              // nasumican broj 1-4
int t = 4;
int rp = 4;             // varijabla za tipkalo 1-3
int igra_li_se = 1;
int c = 0;              // counter pogodaka
int kraj = 0;


// interrupti za botune
void zaustavi_igru(void); // tester
void t1(void);
void t2(void);
void t3(void);


// funkcije
void start_sekvenca(){ // start fja
    // 7 seg spin
    int s;                      
    for (s = 0; s < 4; s++){
        Seg1=SegConvert(10);
        
        wait(0.05);
        Seg1=SegConvert(11);
        wait(0.05);
        Seg1=SegConvert(12);
        wait(0.05);
        Seg1=SegConvert(13);
        wait(0.05);
        Seg1=SegConvert(14);
        wait(0.05);
        Seg1=SegConvert(15);
        wait(0.05);
    }
    Seg1=SegConvert(10);
    wait(0.05);
    Seg1=SegConvert(99);
    wait(0.2);
    
    Seg1=SegConvert(98);
    wait(0.1);
    Seg1=SegConvert(99);
    wait(0.1);
    Seg1=SegConvert(98);
    wait(0.1);
    Seg1=SegConvert(99);
    wait(0.1);
    
    Seg1=SegConvert(99);
    wait(0.5);
    
    // buzzer countdown
    buzzer.period(1/(349.2));
    buzzer = 0.5;
    wait(0.5);
    buzzer = 0;
    wait(0.5);
    buzzer.period(1/(349.2));
    buzzer = 0.5;
    wait(0.5);
    buzzer = 0;
    wait(0.5);
    buzzer.period(1/(349.2));
    buzzer = 0.5;
    wait(0.5);
    buzzer = 0;
    wait(0.5);
    buzzer.period(1/(698.5));
    buzzer = 0.5;
    wait(1);
    buzzer = 0;
}

void end_sekvenca(){
    buzzer.period(1/(698.5));
    buzzer = 0.5;
    wait(0.5);
    buzzer.period(1/(659.3));
    buzzer = 0.5;
    wait(0.5);
    buzzer.period(1/(622.2));
    buzzer = 0.5;
    wait(0.5);
    buzzer.period(1/(587.3));
    buzzer = 0.5;
    wait(0.5);
    buzzer.period(1/(554.4));
    buzzer = 0.5;
    wait(1.5);
    buzzer = 0;
}

// generira nasaumičan broj
unsigned int nasumican (void){
    unsigned int rd = 0;
    unsigned int dugi = 0;
    for (rd = 0; rd <= 32; rd += 2){
        dugi += ((analog.read_u16() ) << rd);
    }
    return dugi;
}


// ticker za odbrojavanje vremena između generiranja krtica
Ticker nova_krtica;

// generira nove krtice i uspoređuje
void krtica(){      
    
    if(r == t){
        c++;
        if(t != 4){
            buzzer.period(1/(587.3));
            buzzer = 0.5;
            wait(0.05);
            buzzer = 0;
        }
        igra_li_se = 1;
    }
  
    else if(r != t){
        igra_li_se = 0;
        Seg1=SegConvert(99);
    }

    rp = r;
    
    r = nasumican() % 4 + 1;
    
    if(r == rp){
        r++;
    }
    if(r > 4){
        r = 1;
    }
    
    switch(r){
           case 1 : Seg1=SegConvert(10);break;
           case 2 : Seg1=SegConvert(16);break;
           case 3 : Seg1=SegConvert(13);break;
           case 4 : Seg1=SegConvert(99);t=4;break; // t je 4, ako se stisne tipkalo ispadaš
    }
    
}


// main
int main() {
    
    pc.printf("\n\r\n\r\n\r\n\r\n\r\n\r\n\r");
    pc.printf("\n\r\n\r-----------\n\r\n\r NOVA IGRA\n\r\n\r-----------\n\r");
    pc.printf("\n\r\n\r\n\r\n\r\n\r\n\r\n\r");
    
    start_sekvenca();
    
    debounce.start();
    
    tipka1.mode(PullUp);
    tipka2.mode(PullUp);
    tipka3.mode(PullUp);
    
    nova_krtica.attach(&krtica,0.7);
    
    while(1) {
        tester.rise(&zaustavi_igru);
        tipka1.rise(&t1);
        tipka2.rise(&t2);
        tipka3.rise(&t3);
        if(igra_li_se == 1){
            // pc.printf("tipka %i     segment%i\n\r", t, r);
        }
        else if(igra_li_se == 0){
            Seg1=SegConvert(99);
            nova_krtica.detach();
            if(kraj==0){
                end_sekvenca();
                kraj++;
            }
            led1 = !led1;
            t = 0;
            pc.printf("\n\r!!! GAME OVER !!!\n\r\n\rPOGODILI STE %i PUTA! WOW!\n\r\n\r??? IGRAJ OPET ???\n\r\n\r", (c-1));
            wait(10);
        }
        
    }
}


//prekidi

// prekid za B1 u svrhe testiranja
void zaustavi_igru(void){
    if(debounce.read_ms()>100){
    led1 = !led1;
//    igra_li_se = 0;
    debounce.reset();
    }
}

//tipka1
void t1(void){
    if(debounce.read_ms()>100){
    
    t = 1;
    led1 = !led1;
    Seg1=SegConvert(99);
    
    debounce.reset();
    }
}

//tipka2
void t2(void){
    if(debounce.read_ms()>100){
    
    t = 2;
    led1 = !led1;
    Seg1=SegConvert(99);
    
    debounce.reset();
    }
}

//tipka3
void t3(void){
    if(debounce.read_ms()>100){
    
    t = 3;
    led1 = !led1;
    Seg1=SegConvert(99);
    
    debounce.reset();
    }
}


// 7 seg konverter
char SegConvert(char SegValue) {        // A 10 (D5), G 16 (D11), D 13 (D8)
 char SegByte=0x00;
 switch (SegValue) { //DPGFEDCBA
 case 0 : SegByte = 0x3F;break; // 00111111 binary
 case 1 : SegByte = 0x06;break; // 00000110 binary
 case 2 : SegByte = 0x5B;break; // 01011011 binary
 case 3 : SegByte = 0x4F;break; // 01001111 binary
 case 4 : SegByte = 0x66;break; // 01100110 binary
 case 5 : SegByte = 0x6D;break; // 01101101 binary
 case 6 : SegByte = 0x7D;break; // 01111101 binary
 case 7 : SegByte = 0x07;break; // 00000111 binary
 case 8 : SegByte = 0x7F;break; // 01111111 binary
 case 9 : SegByte = 0x6F;break; // 01101111 binary
 
 case 10: SegByte = 0x01;break; // 00000001 A
 case 11: SegByte = 0x02;break; // 00000010 B
 case 12: SegByte = 0x04;break; // 00000100 C
 case 13: SegByte = 0x08;break; // 00001000 D
 case 14: SegByte = 0x10;break; // 00010000 E
 case 15: SegByte = 0x20;break; // 00100000 F
 case 16: SegByte = 0x40;break; // 01000000 G
 case 98: SegByte = 0x49;break; // 01001001 AGD
 case 99: SegByte = 0x00;break; // 00000000 /
 }
 return SegByte;
}