#include "mbed.h"
#include "SegDisplay.h"

AnalogIn Ain(A0);           //Analogni ulaz sa potenciometra
InterruptIn button(PC_13);  //Prekid na PC_13 (korisnički gumb)
DigitalOut led1(D11);       // Zelena led dioda na D11
Timer debounce;             // Definira debaunce tajmer
Ticker time_up;         //Definiranje tickera

int n, i, upisanoint; 
int upisano[4]= {0, 0, 0, 0};//trenutno upisana lozinka
int lozinkaint =1234;//zadana lozinka
void toggle(void); // function pritiska gumba
void led_switch(void);//funkcija blinkanja ledice

int main()   // main program
{
    debounce.start();
    SegInit(); 
    while (1) { //glavna petlja
        n=(Ain*9);
        Seg1 = SegConvert(n); // prikaz trenutne vrijednost 
        button.rise(&toggle); // prekid
    }
}

void toggle()
{
    if (debounce.read_ms()>200)
        for(i=0; i<4; i++) {
            upisano[i]=upisano[i+1];
        }
    upisano[3]=n;

    upisanoint= ((upisano[0]*1000)+(upisano[1]*100)+(upisano[2]*10)+(upisano[3]));

    if (upisanoint==lozinkaint) {
        time_up.attach(&led_switch, 0.2); //ako je upisana lozinka točna blinka ledica
    } else {
        time_up.detach(); //prekida led
    }

    debounce.reset(); // restart tajmera za debaunce
}

void led_switch()  //the function that Ticker will call
{
    led1=!led1;
}





