// Melodije i tempo-i su preuzeti sa interneta

#include "Music.h"
#include "pitches.h"
#include "tempos.h"

float default_tempo = float(animato); // default tempo - beats per minute
float current_tempo = default_tempo;

// Holds timings for each defined note/rest time value
float timings[7] = {
    60 / float(current_tempo) * 4, 60 / float(current_tempo) * 3,
    60 / float(current_tempo) * 2, 60 / float(current_tempo),
    60 / float(current_tempo) / 2, 60 / float(current_tempo) / 4,
    60 / float(current_tempo) / 8};

// We wish you a merry Christmas
float wish_tempo = float(animato);

int wish_melody[] = {
    NOTE_D4, NOTE_G4, NOTE_G4,  NOTE_A4,  NOTE_G4,  NOTE_FS4, NOTE_E4,  NOTE_E4,
    NOTE_E4, NOTE_A4, NOTE_A4,  NOTE_B4,  NOTE_A4,  NOTE_G4,  NOTE_FS4, NOTE_D4,
    NOTE_D4, NOTE_B4, NOTE_B4,  NOTE_C5,  NOTE_B4,  NOTE_A4,  NOTE_G4,  NOTE_E4,
    NOTE_D4, NOTE_D4, NOTE_E4,  NOTE_A4,  NOTE_FS4, NOTE_G4,  NOTE_D4,  NOTE_G4,
    NOTE_G4, NOTE_G4, NOTE_FS4, NOTE_FS4, NOTE_G4,  NOTE_FS4, NOTE_E4,  NOTE_D4,
    NOTE_A4, NOTE_B4, NOTE_A4,  NOTE_G4,  NOTE_D5,  NOTE_D4,  NOTE_D4,  NOTE_D4,
    NOTE_E4, NOTE_A4, NOTE_FS4, NOTE_G4};

float wish_note_durations[] = {
    crot, crot,  quav, quav, quav, quav, crot,  crot,  crot, crot, quav,
    quav, quav,  quav, crot, crot, crot, crot,  quav,  quav, quav, quav,
    crot, crot,  quav, quav, crot, crot, crot,  minim, crot, crot, crot,
    crot, minim, crot, crot, crot, crot, minim, crot,  crot, crot, crot,
    crot, crot,  quav, quav, crot, crot, crot,  minim};

// Silent night
float silent_night_tempo = float(animato);

int silent_night_melody[] = {
    NOTE_G4, NOTE_A4, NOTE_G4, NOTE_E4, NOTE_G4, NOTE_A4, NOTE_G4, NOTE_E4,
    NOTE_D5, NOTE_D5, NOTE_B4, NOTE_C5, NOTE_C5, NOTE_G4, NOTE_A4, NOTE_A4,
    NOTE_C5, NOTE_B4, NOTE_A4, NOTE_G4, NOTE_A4, NOTE_G4, NOTE_E4, NOTE_A4,
    NOTE_A4, NOTE_C5, NOTE_B4, NOTE_A4, NOTE_G4, NOTE_A4, NOTE_G4, NOTE_E4,
    NOTE_D5, NOTE_D5, NOTE_F5, NOTE_D5, NOTE_B4, NOTE_C5, NOTE_E5, NOTE_C5,
    NOTE_G4, NOTE_E4, NOTE_G4, NOTE_F4, NOTE_D4, NOTE_C4};

float silent_night_note_durations[] = {crot + quav, quav,
                                       crot,        dot_minim,
                                       crot + quav, quav,
                                       crot,        dot_minim,
                                       minim,       crot,
                                       dot_minim,   minim,
                                       crot,        dot_minim,
                                       minim,       crot,
                                       crot + quav, quav,
                                       crot,        crot + quav,
                                       quav,        crot,
                                       dot_minim,   minim,
                                       crot,        crot + quav,
                                       quav,        crot,
                                       crot + quav, quav,
                                       crot,        dot_minim,

                                       minim,       crot,
                                       crot + quav, quav,
                                       crot,        dot_minim,
                                       dot_minim,   crot,
                                       crot,        crot,
                                       crot + quav, quav,
                                       crot,        dot_minim + dot_minim};

// Jingle bells
float jingle_bells_tempo = float(default_tempo * 2);

int jingle_bells_melody[] = {
    NOTE_B3, NOTE_B3, NOTE_B3, NOTE_B3, NOTE_B3, NOTE_B3, NOTE_B3,
    NOTE_D4, NOTE_G3, NOTE_A3, NOTE_B3, NOTE_C4, NOTE_C4, NOTE_C4,
    NOTE_C4, NOTE_C4, NOTE_B3, NOTE_B3, NOTE_B3, NOTE_B3, NOTE_A3,
    NOTE_A3, NOTE_B3, NOTE_A3, NOTE_D4, NOTE_B3, NOTE_B3, NOTE_B3,
    NOTE_B3, NOTE_B3, NOTE_B3, NOTE_B3, NOTE_D4, NOTE_G3, NOTE_A3,
    NOTE_B3, NOTE_C4, NOTE_C4, NOTE_C4, NOTE_C4, NOTE_C4, NOTE_B3,
    NOTE_B3, NOTE_B3, NOTE_D4, NOTE_D4, NOTE_C4, NOTE_A3, NOTE_G3};

float jingle_bells_note_durations[] = {
    crot,  crot, minim, crot,  crot,  minim, crot, crot,  crot, crot,
    semib, crot, crot,  crot,  crot,  crot,  crot, crot,  crot, crot,
    crot,  crot, crot,  minim, minim, crot,  crot, minim, crot, crot,
    minim, crot, crot,  crot,  crot,  semib, crot, crot,  crot, crot,
    crot,  crot, crot,  crot,  crot,  crot,  crot, crot,  semib};