#ifndef MBED_BUZZER_H
#define MBED_BUZZER_H

#include "mbed.h"

namespace mbed {

/**
 * Class: Buzzer
 *  A class which uses PWM to create sounds on given PWM pin.
 */
class Buzzer {

public:
  Buzzer(PinName pin); // Specified PwmOut pin for buzzer

  /**
   * Buzzer with given frequency and duration.
   *
   * @param frequency - the frequency of the tone in Hz
   * @param time - the duration of the tone in seconds
   */
  void buzz(float frequency, float time);

  /**
   * Silences the buzzer.
   */
  void silence();

private:
  PwmOut _pwm;
  Timeout toff;
};

} // namespace mbed
#endif