#include "Buzzer.h"

using namespace mbed;

Buzzer::Buzzer(PinName pin) : _pwm(pin) { _pwm.write(0.0); }

void Buzzer::silence() { _pwm.write(0.0); }
void empty() {
}

/**
 * Buzzer with given frequency and rithm.
 *
 * @param frequency - the frequency of the tone in Hz
 * @param rithm - rithm of the song
 */
void Buzzer::buzz(float freq, float rithm) {
  _pwm.period(1.0 / freq);
  _pwm.write(0.5f);
    ThisThread::sleep_for(Kernel::Clock::duration_u32((int)(rithm * 500)));
}
