Program koji simulira božični ugođaj reprodukcijom
zvučnih signala na temelju odabira putem tipkala.

# Komponente
## Hardware na proto board-u
- Gumb - Mijenja melodiju na klik (1...n) - Hardware interrupt
- Potenciometar - Mjerenje vrijednosti na ulazu (0.0-1.0) - Potrebno za mjerenje vremena promjene pjesme
- Zvučnik - Reprodukcija melodije
- Zuta LED - Signalizacija da traje melodija jingle bells
- Crvena LED - Signalizacija da traje melodija We wish you a merry christmas
- Zelena LED - Signalizacija da traje melodija Silent night

## Interni hardware
- Ticker - Automatsko mijenjanje melodije u vremenu ovisnom o potenciometru (samo u modu `MODE_AUTO`)
    - *0V = 5s*
    - *1V = 25s*
    - *`f(x) = 5 + 20*x [s]`* - Skaliranje funkcije pomaknute za 5s (min = 5s, max = 25s)
- Timer #1 - Mjerenje vremena trajanja melodije
- Timer #2 - Debounce efekt za gumb

## Software
### Melodije

Postoje 3 melodije: 
- Jingle bells
- We wish you
- Silent night. 
Ovisno o trenutnoj melodiji, svijetli pripadajuca LEDica.

### Modovi rada
Postoje 3 moda rada:
- `MODE_OFF` - Sustav je ugašen - Buzzer ugašen kao i sve LEDice
- `MODE_SONG` - Repetetivno ponavljanje odabrane melodije - Buzzer svira, te svijetli jedna od pripadajucih LEDica za trenutnu melodiju
- `MODE_AUTO` - Automatsko mijenjanje melodije u vremenskom razmaku odabranom putem potenciometra - Buzzer svira, te svijetli jedna od pripadajucih LEDica za trenutnu melodiju

### Buzzer i reprodukcija
Reprodukcija zvukova izvedena je kroz [Buzzer library](https://os.mbed.com/teams/TVZ2022/code/Pavetic_BuzzerLib/) koji sadrži programski kod potreban za inicijalizaciju PWM izlaza za buzzer i slanje pripadajucih signala na navedeni izlaz.

### Pjesme
Inicijalizacija zvukova i sama struktura nota (pwm period + delay) napravljena je kroz [Music library](https://os.mbed.com/teams/TVZ2022/code/Pavetic_MusicLib/).

# Opis rada programa:
Na početku programa postavljen je mod `MODE_OFF` te je sustav ugašen.
Pritiskom na gumb u modu `MODE_OFF` (prvi pritisak gumba), mijenja se mod u
`MODE_SONG` te počinje svirati prva od ponudenih melodija. Nakon sto melodija
zavrsi, ukoliko nije došlo do promjene melodije ili prekida, ponovno se
započinje sa reprodukcijom iste melodije. Ukoliko tijekom reprodukcije dođe
do promjene moda ili melodije, trenutna melodija prekida sa reprodukcijom te
počinje reprodukcija sljedeće melodije, ili se sustav gasi ukoliko je došlo
do promjene moda u `MODE_OFF`.

Program je u modu `MODE_SONG` te svira prva pjesma i upaljena je zuta LEDica.
Drugim pritiskom gumba, mode ostaje isti, no mijenja se melodija te svira
druga melodija i svijetli crvena LEDica. Trećim pritiskom gumba, mod i dalje
ostaje isti i svira treca melodija uz upaljenu zelenu LEDicu.

Cetvrtim pritiskom gumba mijenja se mod u `MODE_OFF` te se resetira ciklus
melodija i započinje reprodukcija prve melodije. Melodija se reproducira
ovisno o vremenu izračunatom iz vrijednosti na potenciometru prema određenoj
formuli koja je navedena na vrhu. Nakon isteka vremena, mijenja se melodija i
započinje reprodukcija sljedeće melodije, te tako u krug sa svim melodijama.
 - Vrijednost potenciometra očitava se cijelo vrijeme na zasebnom Threadu.
 - Vrijeme reprodukcije melodije u modu `MODE_OFF` izračunava se kod dolaska u taj mode.

Petim pritiskom gumba, prekida se reprodukcija melodije te se mod mijenja u
`MODE_OFF` i program nastavlja ispočetka.