#include "mbed.h"
#include "Signal.h"
#include "TextLCD.h"

Signal led4(PB_4);
AnalogIn LM35(PA_0);
DigitalOut led1(PA_8);
DigitalOut led2(PB_3);
DigitalOut led3(PA_5);
DigitalOut fan(PA_6);
InterruptIn button(PB_10);
Timer debounce;
Ticker signal;
TextLCD lcd(PA_10,PB_5,PA_9,PC_7,PB_6,PA_7); //RS,E,D4,D5,D6,D7

void toggle(void);
float temperature(float value);

void signal_diode()
{
    led2 = !led2;
}

float temperature(float value)
{
    float temp;
    float Vout;
    int Vref = 5000;
    Vout = (value * Vref);
    temp = (Vout/10);
    return temp;
}

int main()
{
    float value;
    float T;
    char c = '.';
    int i;
    button.mode(PullUp);
    debounce.start();
    button.rise(&toggle);
    led2 = 0;
    led3 = 1;
    signal.attach(&signal_diode, 1);
    for (i = 7; i < 16; i++) {
        lcd.locate(0,0);
        lcd.printf("LOADING");
        lcd.locate(0,1);
        lcd.printf("Please wait.");
        lcd.locate(i,0);
        lcd.printf("%c", c);
        wait(0.5);
    }
    while(1) {
        lcd.cls();
        lcd.printf("Temp:");
        value = LM35.read();
        T = temperature(value);
        lcd.locate(6,0);
        lcd.printf("%.2f C",T);
        if (T < 18) {
            lcd.locate(3,1);
            lcd.printf("Prohladno!");
            led4.light(0);
        } else if (T >= 18 && T < 24) {
            lcd.locate(5,1);
            lcd.printf("Toplo!");
            led4.light(1);
        } else if (T >= 24) {
            lcd.locate(5,1);
            lcd.printf("Vruce!");
            led4.light(2);
        }
        wait(1);
    }
}

void toggle()
{
    if (debounce.read_ms()>200)
        fan=!fan;
    if (fan) {
        lcd.cls();
        led1 = 1;
        led3 = 0;
        lcd.locate(0,0);
        lcd.printf("Fan: ON");
        wait(1);
    } else {
        lcd.cls();
        led1 = 0;
        led3 = 1;
        lcd.locate(0,0);
        lcd.printf("Fan: OFF");
        wait(1);
    }
    debounce.reset();
}

