#include "mbed.h"
#include "tempRegulator.h"
#include "SegDisplay.h"


AnalogIn LM35(PA_0); // Setting pin PA0 (A0) as Anlog Input
AnalogIn ana2(PA_1); // Setting pin PA1 (A0) as Anlog Input
DigitalOut led1(LED1);
DigitalOut fanOut(D2);
Ticker measure;
Serial pc(SERIAL_TX, SERIAL_RX); // Create an object of Serial Class
char SegConvert(char SegValue);
void takeMasurement(void);
void setTemperatureLimit(void);
InterruptIn confirm(PC_13);
Timer debounce;
Timer timer1;

int blinky = 1;
int tempLimit = 100;
float temperature;
int huh;
int n;


// provjera dali je temperatura viša od dozvoljene 
void takeMasurement()
{                       
        if (temperature > tempLimit){
                led1 = 1;
                fanOut = 1;
            }
        else if (temperature < (tempLimit - 2) ){
            led1 = 0;
            fanOut = 0;
            }
    
     
}

int main()
{
    confirm.rise(&setTemperatureLimit);
   measure.attach(&takeMasurement,2);
     timer1.start();
    debounce.start();
   

    while (1) {
        
        
        temperature = getTemps(LM35);
            huh = temperature * 10 ;
            pc.printf("lm35 = %.1f ^C\r\n", temperature);
           Seg3 = SegConvert((int)(huh % 10));
            Seg2 = SegConvertDot( ((int)temperature)%10);
            Seg1 = SegConvert(int(temperature/10));
            
            wait(1);
       

    }
    
}

// postavljanje maksimalno dozvoljene temperature 
void setTemperatureLimit()
{
        
        timer1.reset();
    if (debounce.read_ms()>500) {
       
        
        pc.printf("getting limit for temps \n");
        while (1) {
            
            Seg3 = SegConvert(10);

            int currentInput = getMaxTemp(ana2);
            pc.printf("%i \n\r", currentInput);
            if (blinky < 5) {

                Seg2 = SegConvert(currentInput % 10);
                Seg1 = SegConvert(currentInput / 10);
                blinky++;
            } else if (blinky > 4 && blinky <6) {
                Seg2 = SegConvert(10);
                Seg1 = SegConvert(10);
                blinky++;
            } else {
                blinky = 1;
            }

            if (confirm == 0) {
                pc.printf("limit get: %i \n", currentInput);
                Seg2 = SegConvert(currentInput % 10);
                Seg1 = SegConvert(currentInput / 10);
                tempLimit = currentInput;
                wait(1);
                break;
            }
            if (timer1.read_ms()>=20000){
                break;
                }
        }


        debounce.reset();
    }

}


