#include "mbed.h"
#include "segdisp.h"
#include "buzzer.h"

#define vrijeme_cekanja 500
#define vrijeme_test_moda 3000
 

AnalogIn Ain(PA_0); //potenciometar
DigitalOut Zelena (PB_8); //Zelena LEDica
DigitalOut Zuta (PB_5); //Zuta LEDica
DigitalOut Crvena (PA_10); //Crvena LEdica
InterruptIn Tipkalo (PB_9); //Tipkalo za Interrupt
Buzz buzzer(PA_4); //DO za buzzer

Ticker treptanje; //ticker za blink LEDice
Timer debouncing_timer; //Timer za debouncing

int stanje=1, testmod_stanje=0, SegDisp_prikaz=0; // definiranje i inicijalizacija 
float razina=0;  // definiranje i inicijalizacija 

void toggle (void); //inicijaliazcija funkcije toggle (HW interrupt)


void trenutno_stanje (float razina) //postavljanje trenutnog stanja 1-prazan;2-ima tekućine;3-pun.
{ 
if (razina < 1.00) //osiguranje zbog mogućeg variranja vrijednosti AI , postavi stanje 1
    { stanje=1;}

if (razina >=1.00 && razina <99 ) //ukoliko se spremnik puni ili prazni (odnosno između praznog i potpuno punog) postavi stanje 2
    {stanje=2;}

if (razina >=99 )  //ukoliko je pun, postavi stanje 3
    { stanje=3;}

}

  void crvena_treptanje (){  //funkcija za treptanje crvene LEDice
    Crvena=!Crvena; 
    }


void stanja_signalizacije (float razina) {//ovisno o stanju prazan, pun, medustanje - postavi signalizaciju


    if (razina < 1.00) //varira vrijednost AI, ukoliko je mjerenje manje od 1% onda je signalizacija da je spremnik prazan
    {
        
        Crvena = 0; //crvena LED isk
        Zuta = 0;  //zuta isk
        Zelena = 1; //crvena uklj
        buzzer.buzzOff(); //buzzer ugašen (klasa)
        Segmentni = Segmentniprikaz(SegDisp_prikaz/10); //int od 0-100 se skalira /10 kako bi dobio broj za prikaz na segmentnom

       
    }

    if (razina >=1.00 && razina <99) //ukoliko se spremnik puni ili prazni (odnosno između praznog i potpuno punog signalizacija zuta)
    {
       
        Crvena = 0;
        Zuta = 1;
        Zelena = 0;
        treptanje.detach();
        buzzer.buzzOff();
        stanje=2;
        Segmentni = Segmentniprikaz(SegDisp_prikaz/10);
      
    }
    if (razina >=99) 
    {
        
        Zuta = 0;
        Zelena = 0;
        treptanje.attach(&crvena_treptanje, 0.5); //ticker - treptanje crvene LEDice - funkcija, period
        buzzer.buzz();
        Segmentni = Segmentniprikaz(SegDisp_prikaz/10);
        
    }

}

    int main() {

    Tipkalo.mode(PullUp); //PullUp otpornik za tipkalo
    Tipkalo.rise(&toggle); //ukoliko se pritisne tipaklo ide u toggle funkciju
    debouncing_timer.start();//start timera za debouncing

  

    while (1)
    {
        
        razina = Ain*100; //skaliranje razine - %
        SegDisp_prikaz=razina;//prikaz razine
  
  
  if(testmod_stanje==1) //pritiskom na tipkalo aktivira se test mode. U test modeu trebaju sve ledice svijetliti, biti upaljeni sve segmenti na display-u (i točka) te buzzer raditi.
    {                          //vrijeme test modea je trenutno podešeno na 3 sekude (u zaglavlju)
        treptanje.detach(); //detach treptanje(iskljuci)
        Zelena=1; //uklj zelenu
        Zuta=1; //uklj zutu
        Crvena=1; //ukljuci crvenu
        buzzer.buzz(); //upali buzzer
        printf("Test mod ukljucen!"); //prikazi da je test mod ukljuce
        Segmentni = Segmentniprikaz(12); //prikazi ono što je na case 12 (svi segmenti uklj)
        wait (vrijeme_test_moda); //čekaj 3 sekunde (trajanje test moda)
        testmod_stanje=0; //postavi test mod u 0, ugasi ga
        
    }
    

    trenutno_stanje(stanje); //pozivanje funkcije za trenutno stanje
    
      if(stanje==1) {  
             
                printf("Trenutna razina u spremniku = %f \n",  razina); //ispis razine
                wait(vrijeme_cekanja); //čekanje
                stanja_signalizacije(razina); //postavi signalizaciju prema funkciji
              
    }
    
      if(stanje==2) {  

                printf("Trenutna razina u spremniku = %f \n",  razina);
                wait(vrijeme_cekanja);//čekanje 500ms 
                stanja_signalizacije(razina);
              
    }

      if(stanje==3) {  

                printf("Trenutna razina u spremniku = %f \n",  razina);
                wait(vrijeme_cekanja);//čekanje 500ms 
                stanja_signalizacije(razina);
                
    }
   
 }

}

void toggle() { //funkcija za toggle tipkala

    if (debouncing_timer.read_ms()>200){ // timer za debounce 200ms
                  
         testmod_stanje=1; //postavi test mod u 1
        }
debouncing_timer.reset(); // reset timera za debounce
}
    
