#include "mbed.h"
#include "buzzer.h"

Beep buzzer(A3);            //pin A3 za buzzer

DigitalOut crvena(A0);      //inicijalizacija crvene led lampice
DigitalOut zuta(A1);        //inicijalizacija zute led lampice
DigitalOut zelena(A2);      //inicijalizacija zelene led lampice
DigitalOut LED(LED2);       //inicijalizacija integrirane led lampice


InterruptIn daljinski(USER_BUTTON);  //inicijalizacija tipkala


Timer debounce;             //inicijalizacija debounce timera
Timer odbrojavanje;         //inicijalizacija timera
Ticker tick;                //inicijalizacija tickera
float freq = 850;           //frekvencija zvuka

void klik (void);           //inicijalizacija funkcije
void otvaranje (void);      //inicijalizacija funkcije
void prekid(void);          //inicijalizacija funkcije

int main()
{
    crvena = 1; //vrata zatvorena

    debounce.start();
    daljinski.rise(&klik);  //hardverski interupt
    while (1) {

        if (odbrojavanje.read() < 10) {     //postavljanje vremenskog uvjeta

            if (LED == 0) {                 //uvjet provjere stanja integrirane ledice
                tick.attach(&otvaranje,1);  //pozivanje funkcije otvaranje pomoću tickera
            }
        }

        if (odbrojavanje.read() > 10) {     //postavljanje vremenskog uvjeta
            zelena = 1;                     //vrata otvorena
        }
    }
}



void klik(void)             //funkcija za debounce i mijenjanje stanja integrirane ledice
{
    if (debounce.read_ms()>200) {
        crvena = 0;
        zelena = 0;
        LED=!LED;  //promjena stanja integrirane ledice
        odbrojavanje.start(); 
        debounce.reset();  
    }
}

void otvaranje(void)        //funkcija za signalizaciju promjenom stanja zute ledice i pokretanje buzzera
{
    crvena = 0;      
    zuta = !zuta;  //promjena stanja zute ledice
    buzzer.beep(freq,0.5);  //frekvencija melodije i trajanje melodije
    if (odbrojavanje.read() > 10) { //uvjet za deaktivaciju zute ledice i buzzera
        zuta = 0;
        buzzer.nobeep();
    }
}
