
#include "mbed.h"
InterruptIn tipkalo (D15); //Prekid za tipkalo na D15
DigitalOut A (D13); //Zelena LED
DigitalOut B (D11); //Zuta LED
DigitalOut C (D9); //Crvena LED
PwmOut beep(D10); //PWM izlaz za zvucnik
Timer T1;         //Timer
Ticker crvena;    //Ticker za crvenu LED
Ticker zuta;      //Ticker za zutu LED
int i=0;            //pomocne varijable u programu
int k=0;            //pomocne varijable u programu

int trajanje[]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; //Tablica u koju se spremaju vremena trajanja zvucnog signala
int pauza[]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};    //Tablica u koju se spremaju vremena pauziranja zvucnog signala

void flip1(){       //funkcija za invertiranje zute LED
    B=!B;
    }
void flip2(){       //funkcija za invertiranje crvene LED
    C=!C;
    }
    
void start(){       //funkcija kada se pritisne tipkalo i drzi se pritisnuto
    if(i==0) crvena.attach(&flip2,0.3); //crvena LED pocinje i nastavlja treperiti (ticker2) samo kada unosimo svaki novi redoslijed signala
    A=1; //ukljucuje zelenu LED
    T1.stop();
    if(T1.read_ms()>10){ //cekanje da smo sigurni da je tipkalo pritisnuto zbog titranja signala
         pauza[i]=T1.read_ms(); //spremanje trajanaj otpustenog tipkala na i-to mjesto
         T1.reset();
         T1.start();
        } 
    T1.start();    
    }
void stop(){   //funkcija kada se otpusti tipkalo i drzi se otpusteno
    A=0;  //iskljucuje zelenu LED
    T1.stop();
    if(T1.read_ms()>10){ //cekanje da smo sigurni da je tipkalo otpusteno zbog titranja signala
        trajanje[i]=T1.read_ms(); //spremanje trajanja pritisnutog tipkala na i-to mjesto
        T1.reset();
        T1.start();
        i++;
        }
    T1.start();
    }
int main() {
    
A=0; //zelena LED
B=0; //zuta LED
C=0; //crvena LED
   
tipkalo.mode(PullUp);
tipkalo.fall(&start); //interrupt na padajuci brid signala tipkala, pokrece se uzimati redoslijedm, mjeri se vrijeme trajanja spustenog tipkala do dignutog stanja tipkala
tipkalo.rise(&stop);  //interrupt na rastuci brid signala koji pokrece mjerenje vremena od dignutog do spustenog stanjatipkala

beep.period(0.002); //frekvencija zvuka (500Hz)

while(1){
if(T1.read_ms()>3000){ //ogranicenje od 3 sekunde do kojeg se uzimaju uzorci signala od zadnjeg uzetog uzorka sa tipkala
    crvena.detach(); //zaustavlja ce ticker za crvenu LED diodu
    C=0; //crvena LED ide u 0
    zuta.attach(&flip1,0.1); //pokrece se ticker za zutu LED koja treperi prilikom reproduciranja zvuka za zvucniku
    T1.stop(); //zaustavlja se timer
    T1.reset(); //resetira se
    for(k=0;k<i;k++){ //for petlja koja prolazi kroz tablicu trajanje[] i pauza[] te ucitava spremljene vrijednosti te se one reproduciraju zvucno i svjetlosno (zelena LED)  u istom redoslijedu i trajanju kako su spremljene
        beep=0.0; //iskljucen zvuk
        A=0; //zelena LED na 0
        wait_ms(pauza[k]); //cekanje u vrijednosti pauze na k poziciji od pauza[]
        beep=0.5; //PWM zvucnika na 50%
        A=1; //zelena LED na 1
        wait_ms(trajanje[k]); //cekanje u vrijednosti trajanja na k poziciju u tablici od trajanje[]
        }
    beep=0.0;
    i=0; //pomocna varijabla ide na 0 za ponovnu upotrebu
    A=0;
    B=0;
    zuta.detach(); //iskljucuje se ticker za zutu LED diodu, reporduciranje je zavrseno
      }
   }
 } 
