#include "libVrata.h"
#include "mbed.h"

Vrata::Vrata(PinName pinServo): servo(pinServo)
{
    pulsOtvorena = 0.112;     //0.11
    pulsZatvorena = 0.069;  //0.07
    polozaj = 0.09;         // pocetni polozaj vrata - sredina
    brzina = 0.0007;        // brzina kretanja vrata (0.0007)    
    rucno = true;
    servo.period(0.020);    // 50Hz
}

void Vrata::otvori()
{
    rad = 1;
    while(polozaj < pulsOtvorena) {
        polozaj = polozaj + brzina;
        servo = polozaj;
        wait_ms(5);
    }
    rad = 2;
}
void Vrata::zatvori()
{
    rad = -1;
    while(polozaj > pulsZatvorena) {
        polozaj = polozaj - brzina;
        servo = polozaj;
        wait_ms(5);
    }
    rad = -2;
}





