//Konstrukcijski_Kresić_Vatrodojava

#include "mbed.h"
#include "buzzer.h"

Beep buzzer(D2);    //pin D2 za buzzer
DigitalOut red(A2);    //pin A0 digitalni izlaz
DigitalOut yellow(A4);    //pin A1 digitalni izlaz
DigitalOut green(A0);     //pin A2 digitalni izlaz
DigitalOut LED(LED2);     //digitalni izlaz

InterruptIn vatrogasci(USER_BUTTON);    //integrirani pin senzora dolaska vatrogasaca

Timer debounce;
Ticker flipper;

Serial pc(USBTX, USBRX);  //komunikacija s računalom

AnalogIn potencio(A1);   //pin A1 analogni ulaz

float dim;  //varijabla za spremanje količine dima s potenciometra
float freq1 = 850;  //varijabla frekvencija zvuka 1
float freq2 = 550;  //varijabla frekvencija zvuka 2
float vrij = 0.4;  //vrijeme trajanja zvuka


void titranje(void);
void toggle(void);

int main()
{
    pc.printf("\nPostotak dima iznosi : \n\r");
    while (1) {
        dim=potencio;
        pc.printf("%f \n\r",dim);
        wait(vrij);


        if (dim <0.2) {
            while (1) {
                green = 1;
                red = 0;
                yellow = 0;
                pc.printf("Nije uocen dim! Svijetli zeleni indikator\n\r");
                break;
            }
        }
        if (dim >=0.2) {
            green = 0;
            red = 1;
            yellow = 0;
            pc.printf("Uocen dim!! Treperenje crvenog i zutog indikatora\n\r");

            while (1) {
                flipper.attach(&titranje,0.5);
                buzzer.beep(freq1,vrij);  //buzzer određen frekvencijom freq1 i vremenom vrij
                wait(vrij);
                buzzer.beep(freq2,vrij);  //buzzer određen frekvencijom freq2 i vremenom vrij
                break;
            }

        }
        if (dim >=0.2) {
            debounce.start();
            vatrogasci.rise(&toggle);

        }
        if (LED == 1) {
            pc.printf("Vatrogasci stigli na teren!\n\r");
        }
    }
}


void titranje(void)  //za titranje ledica
{
    yellow = !yellow;
    red = !red;

}


void toggle()  //za debounce i mijenjanje stanja integrirane ledice
{
    if (debounce.read_ms()>200)
        LED=!LED;
    green = 0;
    debounce.reset();
}
