#include "mbed.h"
#include "scale.h"                      //Library za linearno skaliranje ulaza

char SegConvert(char SegValue) {        // funkcija 'SegConvert' za 7-segment display za brojanje jedinica
 char SegByte=0x00; 
 switch (SegValue) {                    //Binarni zapis radi lakseg predocenja izlaza na displayu
 case 0 : SegByte = 0b00111111;break;   
 case 1 : SegByte = 0b00000110;break;   
 case 2 : SegByte = 0b01011011;break;   
 case 3 : SegByte = 0b01001111;break;    
 case 4 : SegByte = 0b01100110;break;    
 case 5 : SegByte = 0b01101101;break;    
 case 6 : SegByte = 0b01111101;break;    
 case 7 : SegByte = 0b00000111;break;    
 case 8 : SegByte = 0b01111111;break;    
 case 9 : SegByte = 0b01101111;break;     
 } 
 return SegByte;                        //Vracanje odgovarajuce vrijednosti
}

char LEDConvert(char LEDValue) {        // funkcija 'SegConvert' za 3 LED diode za brojanje desetica
 char LEDByte=0x00; 
 switch (LEDValue) {                    //Binarni zapis radi lakseg predocenja izlaza na LED diodama
 case 0 : LEDByte = 0b00000000;break;    
 case 1 : LEDByte = 0b00000001;break;    
 case 2 : LEDByte = 0b00000011;break;     
 case 3 : LEDByte = 0b00000111;break;    
 } 
 return LEDByte;                        //Vracanje odgovarajuce vrijednosti
}

float freq;                             //Varijabla tipa "float" za spremanje realnih vrijednosti iz varijale "pot" za kasniju obradu
int i;                                  //Varijabla tipa "int" za kasniju pretvorbu iz float u integer varijable "freq"(float) u "i"(integer)

DigitalIn zout(D15);                    //Digitalni ulaz, pritiskom tipkala na D15 generira se zvuk odredjene frekvencije
AnalogIn pot(A0);                       //Analogni ulaz potenciometra za namjestanje frekvencije zvuka
PwmOut zvuk(D10);                       //Digitalni izlaz PWM za generiranje zvuka na zvucniku
Ticker tocka;
DigitalOut tocka_led(D6);               //Digitalni izlaz koji upravlja tockom na 7-segment displayu. Tocka treperi tijekom zvucnog signala

void flip_tocka2(){                     //Funkcija za invertiranje stanja LED diode tocke(DP) na 7-segment displayu
    tocka_led=!tocka_led;               //Invertiranje
       }
void sviraj(){                          //Funkcija koja prilikom izvrsavanja generira zvuk na zvucniku
    zvuk=0.5;                           //Sirina periode signala od 50%
    zvuk.period(1/(freq*100));          //Trajanje periode signala, frekvencija signala, x100 je iz razloga sto je korak namjestanja frekvencije 100 Hz
    }

BusOut Seg1(D3,D2,D7,D8,D9,D4,D5);      //Redoslijed skupa izlaznih pinova za 7-segment display
BusOut LED(D11,D12,D13);                //Redoslijed skupa izlaznih pinova za 3-LED diode

int main() {                            //Glavni program
 tocka_led=0;                           //Postavljanje tocke, GP LED diode na nulu
 zout.mode(PullUp);                     //U mirovanju, pin zout(D15) je u stanju HIGH
 
 while (1) {                            //Trajno izvrsavanje programa do nestanka napajanja
   freq=scale(pot, 0.0, 1.0, 1, 39);    //Skaliranje ulaza prema potrebi, u ovom slucaju od 1 do 39, daje mogucnost generiranja zvuka od 100 Hz do 3900 Hz okretanjem potenciometra
   i=freq;                              //Pretvorba iz float u integer
   Seg1=SegConvert(i%10);               //Zadnje dvije linije koda i ukljucujuci ovu su obrada vrijednosti potenciometra za prikaz jedinica na 7-segment displayu
   LED=LEDConvert(i/10);                //Predzadnje dvije linije koda i ukljucujuci ovu su obrada vrijednosti potenciometra za prikaz desetica na 3 LED diode
   if(zout==0){                         //Interrupt, pritiskom tipkala "zout"(D15) pocinje izvrsavanje koda za generiranje zvucnog signala
    wait_us(50000);                     //Delay od 50ms zbog moguceg osciliranja stanja tipkala
    tocka.attach(&flip_tocka2, 0.1);    //Pokretanje tickera za invertiranje tocke GP LED diode na 7-segment displayu prilikom zvucnog signala
    sviraj();                           //Pokretanje funkcije za generiranje zvucnog signala
    wait_us(3000000);                   //Delay od 3 sekunde koji odredjuje vrijeme zvucnog signala
    tocka.detach();                     //Iskljucenje tickera
    tocka_led=0;                        //Postavljanje GP LED diode na nulu
    zvuk=0;                             //Prestanak generiranja zvucnog signala
    }
   wait_us(100000);                     //Delay od 100ms u glavnom dijelu programa, vrijeme osvjezavanja promjene na displayu
 } 
} 
