/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 *Author: Hrvoje Čudina
 */

#include "mbed.h"                      // Inicijalizacija mbed biblioteke
#include "platform/mbed_thread.h"      // Inicijalizacija mbed_thread biblioteke
#include "Light.h"                     // Inicijalizacija Light biblioteke

InterruptIn button(PA_4);              // Inicijalizacija hardverskog prekida
DigitalOut Yellow(PA_15);              // Inicijalizacija digitalnog izlaza Yellow
Timer debounce;                        // Inicijalizacija tajmera za debounce

void ON(void);                         // Inicijalizacija prototipa funkcije

void Turn_OFF(){                       // Funkcija za primjenu "Ticker" klase
    if (Yellow == 1){
        Yellow = 0;
        }
    }

int main()
{      
    Light LED1(PA_13);  // Inicijalizacija konstruktora klase Light
    Light LED2(PA_14);  // Inicijalizacija konstruktora klase Light
    
    Ticker OFF;         // Inicijalizacija konstruktora klase Ticker
    
    DigitalIn Sensor_1(PA_0); // Inicijalizacija digitalnog ulaza
    Sensor_1.mode(PullUp); // Inicijalizacija moda digitalnog ulaza
    
    DigitalIn Sensor_2(PA_1); // Inicijalizacija digitalnog ulaza
    Sensor_2.mode(PullUp); // Inicijalizacija moda digitalnog ulaza
    
    int n = 200; // Definiranje varijable n
    
    debounce.start(); // Početak odbrojavanja tajmera
    button.rise(&ON); // Dodjela funkcije vanjskom prekidu
    OFF.attach(&Turn_OFF, 5.0); // Dodjela funkcije Ticker konstruktoru

    while (true) {
        
        if (Sensor_1 == 1){         // Provjera stanja senzora_1
            LED1.Flash_control(n);
            }
        else {
            LED1.Flash_off();
            }
            
        if (Sensor_2 == 1){         // Provjera stanja senzora_2
            LED2.Flash_control(n);
            
            }
        else {
            LED2.Flash_off();
            }
            
        
    }
}

void ON(){                          // Definirana funkcija za vanjski prekid
    if(debounce.read_ms()>200){
        Yellow = 1;
        debounce.reset();
        }
    }