/* Kolegij Mikroupravljači
 * Konstrukcijski rad - Abramušić Josip Dominik
 * Copyright (c)
 */

#include "mbed.h"   // Osnovni MBED library
#include"Motor.h"   // Korisnički MOTOR library

Motor M1(PA_5,PA_8);    // Inicijalizacija MOTOR objekta M1
Motor M2(PA_6,PA_9);    // Inicijalizacija MOTOR objekta M2

PwmOut PWM1(PA_8);  // Inicijalizacija PWM objekta PWM1
PwmOut PWM2(PA_9);  // Inicijalizacija PWM objekta PWM2

Ticker Tick;  // Inicjalizacija TICKER objekta Tick

DigitalOut ON(PA_1);    // Inicijalizacija digitalnog izlaza ON
DigitalOut W_LED1(PC_2);    // Inicijalizacija digitalnog izlaza W_LED1
DigitalOut W_LED2(PC_3);    // Inicijalizacija digitalnog izlaza W_LED2

InterruptIn AUTO_TURN(PA_0);  // Inicijalizacija hardverskog prekida AUTO_TURN

Timer debounce; // Inicijalizacija Timer-a za "debounce"

void AutoTURN (void);   // Deklaracija funkcije "AutoTURN"
void WhiteLED (void);   // Deklaracija funkcije "WhiteLED"

int main()  // MAIN funkcija 
{
    W_LED1 = 1; // Inicijalizacija stanja bijelih LED 
    W_LED2 = 0;
    
    Tick.attach(&WhiteLED, 2);  // Pridjeljivanje funkcije "WhiteLED" TICKER-u
    
    PWM1.period_ms(20); // Određivanje perioda za PWM1
    PWM2.period_ms(20); // Određivanje perioda za PWM2
    
    AUTO_TURN.mode(PullUp); // Uklučivanje "PullUp" otpornika na Interrupt pin     
    AUTO_TURN.fall(&AutoTURN);  // Dodjeljivanje funkcije "AutoTURN"

    while (true) {

        debounce.start();   // Početak odbrojavanja TIMER-a "debounce"
        PWM1.pulsewidth_us(M1.Control()); // Pozvanje funkcije "Control"
        PWM2.pulsewidth_us(M2.Control()); // Pozvanje funkcije "Control"
        wait_us(1000);  // Naredba "wait_us" za pozicioniranje motora
    }
}
/* 
   Funkcija "AutoTURN" samostalno okreće servo motore preko Interrupt pina.
   Korsti se FOR petlja za prolaz PWM širine pulsa (ovdje je odabrano 10 us).
*/

void AutoTURN ()    // Inicijalizacija funkcije AutoTURN
{
    if (debounce.read_ms() > 250) 
    {
        ON = 1;
        for(int i = 900; i <=2100; i+=10) 
        {
            PWM1.pulsewidth_us(i); // Pridjeljivanje širine pulsa
            PWM2.pulsewidth_us(i); // Pridjeljivanje širine pulsa
            wait_us(12000);
        }
        ON = 0;
        debounce.reset(); // Ponovno pokretanje TIMER-a
    }
}
/* 
   Funkcija "WhiteLED" naizmjenično pali odnosno gasi bijele LED.
   Dodjeljue se TICKER objektu Tick.
*/
void WhiteLED ()    // Inicijalizacija funkcije WhiteLED
{
   W_LED1 = !W_LED1;
   W_LED2 = !W_LED2;
   wait_us(50000);
}