#include "mbed.h"
#include "buzzer.h"

DigitalOut crvena(D2);
DigitalOut zuta(D3);
DigitalOut zelena(D4);

Beep buzzer(D7);

InterruptIn tipka(USER_BUTTON);
Timer debounce;

bool Tipkalo = false;
void kliknutoTipkalo()
{
    Tipkalo = true;
}

float a4=440.00;
float b3=246.94;
float b4=493.88;
float c4=261.63;
float c5=523.25;
float c5s=554.40;
float d4=293.66;
float d5=587.33;
float e4=329.63;
float e5=659.25;
float f4=349.23;
float f4s=370.00;
float f5=698.46;
float g4=392.00;
float g4s=415.30;
float g5=783.99;

float t1=1;
float t2=2;

float fre[14]= {c4, c4, g4, g4, a4, a4, g4, f4, f4, e4, e4, d4, d4, c4,};
float beat[14]= {t2, t2, t2, t2, t2, t2, t1, t2, t2, t2, t2, t2, t2, t1,};


float time_delay = 0.5;
void lampicegore()
{
    crvena=1;
    zuta=1;
    zelena=1;
}

void lampiceugasene()
{
    crvena=0;
    zuta=0;
    zelena=0;
}

int main()
{
    debounce.start();
    tipka.fall(&kliknutoTipkalo);

    int i;
    while(true) {
        if(Tipkalo ==true) {
            for(i=0; i<14; i++) {
                lampicegore();
                buzzer.beep(fre[i], beat[i]);
                wait(1/beat[i]);
            }
            Tipkalo=false;
            lampiceugasene();
        }
    }
}
