#include "mbed.h" // pozivanje  biblioteke
#include "buzzer.h"

DigitalOut LED_Crvena(D4); //Postavljanje pinova D4 i D5 kao izlaz za signalizaciju diodama
DigitalOut LED_Zelena(D5);

DigitalOut A(D8); // segment A //Postavljanje pinova D8 do D15 kao segmente na displayu
DigitalOut B(D9); // segment B
DigitalOut C(D10); // segment C
DigitalOut D(D11); // segment D
DigitalOut E(D12); // segment E
DigitalOut F(D13); // segment F
DigitalOut G(D14); // segment G
DigitalOut DP(D15); // segment DP

InterruptIn Tipka(USER_BUTTON);//Deklaracija pina USER kao prekid
Timeout Response; 
Beep buzzer(D2);
Ticker ticker;

void sound() {
    if(LED_Zelena == 1) {
        buzzer.beep(400, 1.5);
    } else if(LED_Crvena ==1) {   //vrijeme zujanja ledica
        buzzer.beep(200, 0.5);
    }
}


bool Tipkalo = false;   //postavljanje početne vrijednosti
                               
void Tipkastisnuta() {  //potprogram za detekciju prekida
    Tipkalo = true;
}

void semaforcrveno(){ //glavna funkcija koja radi cijelo vrijeme dok se ne stisne gumb
   LED_Zelena = 0; 
   LED_Crvena=1;
   } 

void pjesackisemafor() { //funkcija koja pali semafor za pjesake nakon detektiranog vanjskog prekida

    if(Tipkalo == true){      
    LED_Crvena = 0;
    wait(0.1);
    LED_Zelena = 1;
;
 A=1; B=1; C=1; D=1; E=0; F=0; G=1; DP=0; // Postavi LEDICE '3'
 wait(1);
 A=1; B=1; C=0; D=1; E=1; F=0; G=1; DP=0; // Postavi LEDICE '2'
 wait(1);
 A=0; B=1; C=1; D=0; E=0; F=0; G=0; DP=0; // Postavi LEDICE '1'
 wait(1);
 A=1; B=1; C=1; D=1; E=1; F=1; G=0; DP=0; // Postavi LEDICE '0'
    Response.attach(&semaforcrveno,0.2);  // naredba kojom se pokreče timeout timer   
    Tipkalo=false; //vraća na pocetnu vrijednost
    }
 
  }     
int main() { 

    ticker.attach(&sound, 1.0); 
    Tipka.fall(&Tipkastisnuta);  // naredba koja detektira interupt promjenom stanja     
    
     while(true){    //beskonačna petlja koja provjerava stanje tipkala te ovisno o tome pokreće funkciju "semaforcrveno" ili "pjesackisemafor"
        if(!Tipka) {  
            semaforcrveno(); 
        } else {
            pjesackisemafor();
        }
      }
    
}