#include "mbed.h"
#include "SegDisplay.h"
 
InterruptIn button1(A0); //Interrupt pin - tipkalo1
InterruptIn button2(A1); //Interrupt pin - tipkalo2
Serial pc(USBTX, USBRX); //Komunikacija s računalom
DigitalOut redLED(A2); //Izlaz crvene LED diode
DigitalOut yellowLED(A3); //Izlaz žute LED diode
DigitalOut greenLED(A4); //Izlaz zelene LED diode
PwmOut speaker(PA_10); //Zvučnik
Ticker blink; //Ticker za blinkanje LED dioda
Timer debounce; //Timer za micanje debouncinga
void toggle(void); //Semafor u kvaru - zaustavlja se rad
void toggle2(void); //Semafor popravljen - pušta se ponovno u rad
int state=1;  // inicijalizacija varijable
int sec=0; // inicijalizacija varijable

void yellowBlink()
{
    yellowLED=!yellowLED;
 
}
 
void odbrojavanje() // Odbrojavanje vremenskog perioda do promjene signalizacije na semaforu
{
    while (sec>0 && state!=5) {
        Seg1 = SegConvert(sec); // Ispisivanje na 7.seg display
        wait_us (1000000);
        sec--;
    }
}
 
void signalizacija(int red, int yellow, int green, int trajanje)  // Signalizacija semafora
{
    redLED = red;
    yellowLED = yellow;
    greenLED= green;
    sec = trajanje;
}
 
int main()
{
    debounce.start();
    SegInit(); // Pozivanje funkcije za inicijalizaciju 7 seg. displaya
    while (true) {
        button1.rise(&toggle); // Interrupt, Semafor trenutno ne radi
        button2.rise(&toggle2); // Interrupt, Semafor ponovno radi
        if(state==1) { // Crveno svijetlo na semaforu
            pc.printf("Zaustavi se.\n");
            blink.detach();
            signalizacija(1,0,0,9);
            state=2;
        } else if(state==2) { // Prijelaz iz crvenog svijetla u žuto zatim u zeleno svijetlo
            pc.printf("Pripremi se za kretanje.\n");
            signalizacija(1,1,0,3);
            state=3;
        } else if(state==3) { // Zeleno svijetlo na semaforu - kreni
            pc.printf("Kreni.\n");
            signalizacija(0,0,1,9);
            state=4;
        } else if(state==4) { // Prijelaz iz zelenoga svijetla u žuto zatim u crveno svijetlo
            pc.printf("Priprema za crveno svijetlo.\n");
            signalizacija(0,1,0,3);
            state=1;
 
        } else  if(state==5) { // Semafor u kvaru
            pc.printf("Semafor u kvaru.\n");
            signalizacija(0,0,0,0);
            blink.attach(&yellowBlink, 0.75); // Ticker za blinkanje LED
            state=6;
            Seg1 = SegConvert(10);
 
        }
        odbrojavanje();
    }
 
}
 
//Interrupt, Semafor u kvaru
void toggle()
{
    speaker.period(1.0/500.0); //Zvučni signal da je semafor od sada u kvaru
    speaker=0.5;
    wait(0.5);
    speaker=0.0;
 
    if (debounce.read_ms()>200) { // only allow toggle if debounce timer
        state=5; // has passed 200 ms
    }
    debounce.reset(); // restart timer when the toggle is performed
 
                }
 
//Interrupt, Semafor više nije u kvaru
void toggle2()
{
    speaker.period(1.0/1000.0); // Zvučni signal da je semafor od sada ponovno u funkciji
    speaker=0.5;
    wait(0.5);
    speaker=0.0;
 
    if (debounce.read_ms()>200) { // only allow toggle if debounce timer
        state=1; // has passed 200 ms
 
    }
    debounce.reset(); // restart timer when the toggle is performed
}
