#include "mbed.h"
#include "Displej.h"


DigitalIn switch_namestanje_min(D3);
DigitalIn switch_namestanje_sat(D2);
InterruptIn button(PB_1);

Timer debounce;
Ticker ticker_min;

int namestit_min=0;
int namestit_sat=0;
int sati=23;
int minute=59;

class Sat{
    public:
        Sat(int pocetniSat,int pocetnaMinute){
            _sati=pocetniSat;
            _minute=pocetnaMinute;
        }
        void prikaz(){
                //Q1
                QSegment=0x01;
                LSegment=SegConvert(_sati,1);// jedan ide kad je polje obratno dok uzimas digite
                wait(0.003);
                //Q2
                QSegment=0x02;
                LSegment=SegConvert(_sati,0);
                wait(0.003);
                //Q2 dvotocka
                QSegment=0x02;
                LSegment=SegConvert(-1,0);
                wait(0.003);
                //Q3
                QSegment=0x04;
                LSegment=SegConvert(_minute,1);
                wait(0.003);
                //Q4
                QSegment=0x08;
                LSegment=SegConvert(_minute,0);
                wait(0.005);
            }
            void setSati(int h){
                _sati=h;
            }
            void setMinute(int m){
                _minute = m;
            }
    private:
        int _sati,_minute;
};

void otkucaj(void);
void toggle(void);

int main(){
    ticker_min.attach(&otkucaj,60.0);
    debounce.start();
    switch_namestanje_min.mode(PullUp);
    switch_namestanje_sat.mode(PullUp);
    button.rise(&toggle);
    Sat sat(sati,minute);
    while(1) {
        namestit_min=switch_namestanje_min==0?0:1;
        namestit_sat=switch_namestanje_sat==0?0:1;
        sat.setSati(sati);
        sat.setMinute(minute);
        sat.prikaz();
    }
}
void otkucaj(){
    if(namestit_sat==1 && namestit_min==1){
        if(minute==59){
            minute=0;
            if(sati==23){
                sati=0;
            }else{
                sati++;
            }
        }else{
            minute++;
        }
    }
}

void toggle() {
    if (debounce.read_ms()>100 && (namestit_min==0||namestit_sat==0)){
        if(namestit_min==0 && namestit_sat==1){
            if(minute<59){
                minute++;
            }else{
                if(sati<23){
                    sati++;
                }else{
                    sati=0;
                }
                minute=0;
            }
        }else if(namestit_min==1 && namestit_sat==0){
            if(sati<23){
                sati++;
            }else{
                sati=0;
            }
        }
    }
    debounce.reset();
}
