/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "TIMEE.h"
#include "platform/mbed_thread.h"

    DigitalOut RED(PB_8);
    DigitalOut YELLOW(PB_9);
    DigitalOut GREEN(PA_5);

void BROKEN (bool n);

int main()
{
    
    DigitalIn BUTTON (PA_0);
    BUTTON.mode (PullUp);
    DigitalIn BUTTON_T(PA_1);
    BUTTON_T.mode (PullUp);
    Timer time;
    
    TIMER T;

    while (true) {
        time.start();
        BROKEN(BUTTON);
    
        int var = 10;
        
        if (BUTTON_T == 1){
            var = T.TIME();
        }
        
        if(time.read() <= var && BUTTON == 0){
        RED = 1;
        GREEN = 0;
        YELLOW = 0;
        }
        if(time.read() > var && time.read() <= 13 && BUTTON == 0){
        RED = 1;
        GREEN = 0;
        YELLOW = 1;
        }
        if(time.read() > 13 && time.read() <= 23 && BUTTON == 0){
        RED = 0;
        GREEN = 1;
        YELLOW = 0;
        }
        if(time.read() > 23  && time.read() <= 26 && BUTTON == 0){
        RED = 0;
        GREEN = 0;
        YELLOW = 1;
        
        }
        if (time.read() > 26 || BUTTON == 1){
            time.reset();
        }
    }
    
}

void BROKEN (bool n) {
    
    if (n == true){
        RED = 0;
        GREEN = 0;
        wait(1);
        YELLOW = !YELLOW;
    }
}