#include "mbed.h"
#include "SegDisplay.h"

Serial pc(USBTX, USBRX);
AnalogIn Ain(A5); // Napon sa senzora na pin A5
DigitalOut hladenje (A1); // Izlaz za ledicu sa pina A1
DigitalOut grijanje (A2); // Izlaz za ledicu sa pina A2
DigitalOut normalno (A3); // Izalaz za ledicu sa pina A3
DigitalOut kvar (A4); // Izlaz za ledicu sa pina A4
PwmOut buzzer (PA_10); // PWM za zvučnik sa pina PA_10
PwmOut buzzer2 (D12);
InterruptIn button(A0); // Tipka za prekidnu rutinu u slučaju kvara na pinu A0
InterruptIn button2(D13); // Tipka za prekidnu rutinu koja resetira program
DigitalOut led1(A4); // Izlaz koji prikazuje prekidnu rutinu
Ticker blink; // Ticker za blinkanje ledice
Timer debounce; // Timer za prekidnu rutinu
void toggle(void); // Prekid rada
void toggle2(void); // 
float ADCdata;
float Temperatura;
int sec=0;

void kvarLEDBlink()
{
    kvar=!kvar;
}
void odbrojavanje() // Odbrojavanje kod određenog stanja
{
    if (sec>0) { // Odbrojavanje 
        Seg1 = SegConvert(sec); // Ispisivanje na 7.seg display
        wait_us (10000);
        sec--;
    }
    if (sec==0) {
        buzzer2.period(1.0/500.0);
        buzzer2=0.5;
        wait(0.5);
        buzzer2=0.0;
        sec=9;
    }
}
void vrijeme (int trajanje)  // Trajanje odbrojavanja
{
    sec = trajanje;
}

int main()
{
    pc.printf("ADC Data Values... \n\r");
    debounce.start();
    SegInit(); // Pozivanje funkcije za 7.seg display
    while (1) {
        ADCdata=Ain;
        pc.printf("Temperatura= %0.0f\n\r",ADCdata*100);
        button.rise(&toggle);
        button2.rise(&toggle2);
        wait (2);
        if (Ain <= 0.20) {
            button.rise(&toggle);
            hladenje = 0;
            grijanje = 1;
            normalno = 0;
            kvar = 0;
            buzzer = 0;
        }
        if ((Ain>0.20)&&(Ain<=0.26)) {
            hladenje = 0;
            grijanje = 0;
            normalno = 1;
            kvar = 0;
            vrijeme (9);
            buzzer = 0;
        }
        if ((Ain>0.26)&&(Ain<=0.47)) {
            hladenje = 1;
            grijanje = 0;
            normalno = 0;
            kvar = 0;
            buzzer = 0;
            odbrojavanje();
        }
        if ((Ain>0.47)&&(Ain<=1.0)) {
            hladenje = 1;
            grijanje = 1;
            normalno = 1;
            kvar = 0;
            int i;
            for (i=0; i<10; i=i+2) {
                buzzer.period(1.0/969.0);
                buzzer = float(i)/50.0;
                wait(.5);
                buzzer.period(1.0/800.0);
                wait(.5);
                pc.printf("ALARM \n\r");
            }
        }
    }
}

void toggle()
{
    if (debounce.read_ms()>200) { // Uvjet za debounce timer
        pc.printf("PREKID! \n");
        blink.attach(&kvarLEDBlink, 0.2); // Ticker za blinkanje ledice
        hladenje = 0;
        grijanje = 0;
        normalno = 0;
        buzzer= 0;
        sec=0;
        buzzer2.period(1/500.0);
        buzzer2=0;
        wait(0.01);
        buzzer2=0.0;
        wait(5);
    }
    debounce.reset(); // Restart timera
}
void toggle2()
{
    if (debounce.read_ms()>200) {
        blink.detach();
    }
}