#include "mbed.h"
#include "libVrata.h"

DigitalOut ledCrvena(p15),ledZuta(p16);
DigitalOut led1(LED1), led4(LED4);

InterruptIn tipkaloCrveno(p11), tipkaloPlavo(p12);

Ticker blink1, blink2;
Timer vrijemeZatvaranja;

AnalogIn aIn19(p19), aIn20(p20);  // analogni ulazi fotootpornika

Vrata vrata(p21);

bool senzorAktiviran(int rbr) // 0 - ulaz,   1 - izlaz
{
    if ((rbr == 0) && (aIn19 < 0.5f)) return true;
    if ((rbr == 1) && (aIn20 < 0.5f)) return true;
    return false;
}

void blinkCrvenaLed()
{
    ledCrvena = ! ledCrvena;
}

void blinkZutaLed()
{
    ledZuta = !ledZuta;
}

void otvoriVrata()
{
    blink1.attach(&blinkCrvenaLed, 0.1);
    vrata.otvori();
    blink1.detach();
    ledCrvena = 0;
}

void zatvoriVrata()
{
    blink1.attach(&blinkCrvenaLed, 0.1);
    vrata.zatvori();
    blink1.detach();
    ledCrvena = 0;
}

void automatikaToggle()  // interrupt plava tipka - izbor rezima rada
{
    vrata.rucno = !vrata.rucno;
    ledZuta = vrata.rucno;
    wait_ms(200);
}

void pokreniVrataRucno()   // rucno upravljanje vratima
{
    if(vrata.rucno) {
        if(vrata.rad < 0) otvoriVrata();
        else if(vrata.rad > 0) zatvoriVrata();
        wait_ms(200);
    }
}

int main()
{
    bool zutaBlink = false; // uključen ticker blinkanja zute Led
    otvoriVrata();  // prvi setup vrata
    wait(2);        //
    zatvoriVrata(); //

    tipkaloCrveno.mode(PullDown);
    tipkaloPlavo.mode(PullDown);
    tipkaloPlavo.rise(&automatikaToggle);
    tipkaloCrveno.rise(&pokreniVrataRucno);
    ledZuta = vrata.rucno;
    
    while(1) {
        led1 = senzorAktiviran(1);
        led4 = senzorAktiviran(0);
        if(!vrata.rucno) { // automatski
            ledZuta = vrata.rucno;
            if(senzorAktiviran(0) || senzorAktiviran(1)) {
                otvoriVrata();
                vrijemeZatvaranja.reset();
                vrijemeZatvaranja.start();
            }
            if(vrijemeZatvaranja.read() > 5.0) {  // automatsko zatvaranje vrata nakon 5 sec
                zatvoriVrata();
                vrijemeZatvaranja.stop();
                vrijemeZatvaranja.reset();
            }
        } else {  // rucno
            if(senzorAktiviran(0) || senzorAktiviran(1)) {
                if(!zutaBlink) {
                    blink2.attach(&blinkZutaLed, 0.2);
                    zutaBlink = true;
                }
            } else if (zutaBlink) {
                blink2.detach();
                zutaBlink = false;
                ledZuta = vrata.rucno;
            }
        }
        wait_ms(20);
    }
}
