#include "mbed.h"
#include "LEDController.h"

#define MINDIFFTIME 200
#define MAXDIFFTIME 350

Serial pc(USBTX, USBRX); // tx, rx
InterruptIn mic(PB_3);
InterruptIn button(PB_4);
Timer debounce;
Timer micTimer;

int measuredTime;

LEDController controller(PB_5, 0.25, false, true);

void button_interrupt();
void mic_interrupt();

int main(){
    pc.baud(9600);
    
    debounce.start();
    button.rise(&button_interrupt);
    mic.rise(&mic_interrupt);
   
    while (true) {
        controller.checkOnOffState();
    }    
}

void mic_interrupt() {
    micTimer.stop();
    
    measuredTime = micTimer.read_ms();
    
    if(measuredTime > 50){ 
        pc.printf("Mikrofon prekid! %d\n\r", measuredTime); 
        if (measuredTime > MINDIFFTIME && measuredTime < MAXDIFFTIME) {
            pc.printf("Pali/gasi!\n\r"); 
            controller.toggleShouldBeOn(); 
        }  
    }
    
    micTimer.reset();
    micTimer.start();
}

void button_interrupt(){
    if(debounce.read_ms() > 200){
        controller.toggleBlinkingMode();
        pc.printf("Blinking mod: %s\n\r", controller.getBlinkingMode()?"true":"false");
    }
    
    debounce.reset();
}