#include "mbed.h"
#include "ikone.h"
#include "SSD1306I2C.h"

Serial pc(USBTX, USBRX);

Timer debounce;
Timer gasenje_zaslona;

InterruptIn desno(D7);
InterruptIn potvrda(D5);
InterruptIn otkaz(D6);
InterruptIn lijevo(D4);

bool aktuator=false;
bool potvrda_ulaska_u_izbornik=false;
bool potvrda_ulaska_u_podizbornik=false;
uint8_t postavka_gasenja_zaslona=15; //5, 15, 30 sekundi
//bool postavka_izbornika=false;

void ispis_desno(void);
void ispis_potvrda(void);
void ispis_otkaz(void);
void ispis_lijevo(void);

SSD1306I2C display(0x3c, D14, D15);

DigitalOut myled(LED1);
void izbornik_tipke(void);

uint8_t izbornik=0;
uint8_t pod_izbornik=0;
uint8_t postavka_izbornika=0;

int main()
{

    desno.rise(ispis_desno);
    potvrda.rise(ispis_potvrda);
    otkaz.rise(ispis_otkaz);
    lijevo.rise(ispis_lijevo);
    display.init();
    display.resetDisplay();
    display.setFont(ArialMT_Plain_10);
    display.drawString(30,0,"Vanja Belosevic");
    display.drawString(35,20,"0246076901");
    display.drawString(38,40,"2021/2022");
    //display.drawStringMaxWidth(0,0,128,"Vanja Belosevic");
    //display.drawStringMaxWidth(0,20,128,"0246076901");
    //display.drawStringMaxWidth(0,40,128,"2021/2022");
    display.display();
    pc.printf("Mirko pokrenut!");
    wait(5);
    display.clear();
    gasenje_zaslona.start();

    while(1) {

        if(gasenje_zaslona >= postavka_gasenja_zaslona) {
            display.displayOff();
        } else {
            display.displayOn();
        }

        if(izbornik == 0 && potvrda_ulaska_u_podizbornik == false && potvrda_ulaska_u_izbornik == false) {
            display.clear();
            display.setFont(ArialMT_Plain_10);
            display.drawString(0,0,"Stanje aktuatora:");
            display.setFont(ArialMT_Plain_16);
            if(aktuator == false) {
                display.drawString(0,20,"OFF");
            } else if(aktuator == true) {
                display.drawString(0,20,"ON");
            }
        } else if(izbornik == 1 || (potvrda_ulaska_u_izbornik == true || potvrda_ulaska_u_podizbornik == true)) {
            if(potvrda_ulaska_u_izbornik == false && potvrda_ulaska_u_podizbornik == false) {
                display.clear();
                display.drawXbm(40,0,48,48,settings_48x48); //x početno, y početno, širina, visina, char polje od slike
            } else if(potvrda_ulaska_u_izbornik == true && potvrda_ulaska_u_podizbornik == false) {
                if(pod_izbornik == 0) {
                    display.clear();
                    display.setFont(ArialMT_Plain_10);
                    display.drawStringMaxWidth(0,0,128,"Odabir stanja aktuatora?");
                } else if(pod_izbornik == 1) {
                    display.clear();
                    display.setFont(ArialMT_Plain_10);
                    display.drawStringMaxWidth(0,0,128,"Odabir perioda automatskog gasenja zaslona?");
                }
            } else if(potvrda_ulaska_u_izbornik == false && potvrda_ulaska_u_podizbornik == true) {
                display.clear();
                display.setFont(ArialMT_Plain_10);
                if(pod_izbornik == 0) {
                    if(postavka_izbornika == 0) {
                        display.drawStringMaxWidth(0,0,128,"Aktuator :");
                        display.setFont(ArialMT_Plain_16);
                        display.drawString(60,30,"OFF?");
                    } else if(postavka_izbornika == 1) {
                        display.drawStringMaxWidth(0,0,128,"Aktuator :");
                        display.setFont(ArialMT_Plain_16);
                        display.drawString(60,30,"ON?");
                    }
                } else if(pod_izbornik == 1) {
                    if(postavka_izbornika == 0) {
                        display.drawStringMaxWidth(0,0,128,"Odabir :");
                        display.drawStringMaxWidth(0,30,128,"5 sekundi?");
                    } else if(postavka_izbornika == 1) {
                        display.drawStringMaxWidth(0,0,128,"Odabir :");
                        display.drawStringMaxWidth(0,30,128,"15 sekundi?");
                    } else if(postavka_izbornika == 2) {
                        display.drawStringMaxWidth(0,0,128,"Odabir :");
                        display.drawStringMaxWidth(0,30,128,"30 sekundi?");
                    }
                }
            }

        }
        izbornik_tipke();
        display.display();
    }
}

//wait(10.0);

//pc.printf("%d\n",x);


void ispis_desno()
{
    debounce.start();
    if(debounce.read_ms() >= 150) {
        pc.printf("desna tipka pritisnuta!\n");
        if(potvrda_ulaska_u_izbornik == false && potvrda_ulaska_u_podizbornik == false) {
            --izbornik;
            if(izbornik >= 2) izbornik = 1;
        } else if(potvrda_ulaska_u_izbornik == true && potvrda_ulaska_u_podizbornik == false) {
            //potvrda_ulaska_u_izbornik = false;
            --pod_izbornik;
            if(pod_izbornik >= 2) pod_izbornik = 1;
        } else if(potvrda_ulaska_u_podizbornik == true && potvrda_ulaska_u_izbornik == false) {
            --postavka_izbornika;
            if(pod_izbornik == 0) {
                if(postavka_izbornika >= 2) postavka_izbornika = 1;
            } else if (pod_izbornik==1) {
                if(postavka_izbornika >= 3) postavka_izbornika = 2;
            }
        }
        debounce.reset();
        display.displayOn();
        gasenje_zaslona.reset();
        pc.printf("Stanje varijable izbornik: %d\n",izbornik);
        pc.printf("Stanje varijable pod_izbornik: %d\n",pod_izbornik);
        pc.printf("Stanje varijable postavka_izbornika %d",postavka_izbornika);
        pc.printf("potvrda_ulaska_u_izbornik: %d\n",potvrda_ulaska_u_izbornik);
        pc.printf("potvrda_ulaska_u_podizbornik: %d\n",potvrda_ulaska_u_podizbornik);
    }

}

void ispis_potvrda()
{
    debounce.start();
    if(debounce.read_ms() >= 150) {
        pc.printf("tipka potvda pritisnuta!\n");
        debounce.reset();
        display.displayOn();
        gasenje_zaslona.reset();
        if(izbornik == 1 && potvrda_ulaska_u_izbornik == false && potvrda_ulaska_u_podizbornik == false) {
            potvrda_ulaska_u_izbornik = true;
            potvrda_ulaska_u_podizbornik = false;
            pod_izbornik = 0;
            postavka_izbornika = 0;
        } else if(potvrda_ulaska_u_izbornik == true && potvrda_ulaska_u_podizbornik == false) {
            potvrda_ulaska_u_podizbornik = true;
            potvrda_ulaska_u_izbornik = false;
        } else if(potvrda_ulaska_u_izbornik == false && potvrda_ulaska_u_podizbornik == true) {
            if(pod_izbornik == 0 && postavka_izbornika == 0) {
                aktuator = false;
            } else if(pod_izbornik == 0 && postavka_izbornika == 1) {
                aktuator = true;
            } else if(pod_izbornik == 1 && postavka_izbornika == 0) {
                postavka_gasenja_zaslona=5;
            } else if(pod_izbornik == 1 && postavka_izbornika == 1) {
                postavka_gasenja_zaslona=15;
            } else if(pod_izbornik == 1 && postavka_izbornika == 2) {
                postavka_gasenja_zaslona=30;
            }
            potvrda_ulaska_u_podizbornik = false;
            potvrda_ulaska_u_izbornik = true;
        }
        pc.printf("potvrda_ulaska_u_izbornik: %d\n",potvrda_ulaska_u_izbornik);
        pc.printf("potvrda_ulaska_u_podizbornik: %d\n",potvrda_ulaska_u_podizbornik);
    }
}

void ispis_otkaz()
{
    debounce.start();
    if(debounce.read_ms() >= 150) {
        pc.printf("tipka otkaz pritisnuta!\n");
        debounce.reset();
        display.displayOn();
        gasenje_zaslona.reset();

        if(potvrda_ulaska_u_izbornik == true && potvrda_ulaska_u_podizbornik == false) {
            pod_izbornik=0;
            izbornik=1;
            potvrda_ulaska_u_izbornik = false;
        } else if(potvrda_ulaska_u_izbornik == false && potvrda_ulaska_u_podizbornik == true) {
            potvrda_ulaska_u_podizbornik = false;
            potvrda_ulaska_u_izbornik = true;
            pod_izbornik=0;
            postavka_izbornika=0;
            izbornik=1;
        }
        pc.printf("potvrda_ulaska_u_izbornik: %d\n",potvrda_ulaska_u_izbornik);
        pc.printf("potvrda_ulaska_u_podizbornik: %d\n",potvrda_ulaska_u_podizbornik);
    }
}

void ispis_lijevo()
{
    debounce.start();
    if(debounce.read_ms() >= 150) {
        pc.printf("lijeva tipka pritisnuta!\n");

        if(potvrda_ulaska_u_izbornik == false && potvrda_ulaska_u_podizbornik == false) {
            ++izbornik;
            if(izbornik >= 2) izbornik = 0;
        } else if(potvrda_ulaska_u_izbornik == true && potvrda_ulaska_u_podizbornik == false) {
            ++pod_izbornik;
            if(pod_izbornik >= 2) pod_izbornik = 0;
        } else if(potvrda_ulaska_u_podizbornik == true && potvrda_ulaska_u_izbornik == false) {
            ++postavka_izbornika;
            if(pod_izbornik == 0) {
                if(postavka_izbornika >= 2) postavka_izbornika = 0;
            } else if (pod_izbornik==1) {
                if(postavka_izbornika >= 3) postavka_izbornika = 0;
            }
        }
        debounce.reset();
        display.displayOn();
        gasenje_zaslona.reset();
        pc.printf("Stanje varijable izbornik: %d\n",izbornik);
        pc.printf("Stanje varijable pod_izbornik: %d\n",pod_izbornik);
        pc.printf("Stanje varijable postavka_izbornika: %d\n",postavka_izbornika);
        pc.printf("potvrda_ulaska_u_izbornik: %d\n",potvrda_ulaska_u_izbornik);
        pc.printf("potvrda_ulaska_u_podizbornik: %d\n",potvrda_ulaska_u_podizbornik);
    }

}

//trajni izbornik na dnu zaslona, sadrži ikone za korištenje tipki
void izbornik_tipke()
{
    display.drawHorizontalLine(0,52,128);
    display.drawXbm(0,55,12,9,strelica_lijevo_12x9);
    display.drawXbm(108,55,12,9,strelica_desno_12x9);
    display.drawXbm(42,55,9,9,x_9x9);
    display.drawXbm(75,55,11,9,check_11x9);
    //display.display();
}
