#include "mbed.h"
#include "segmentDisplay.h"
 
Serial pc(USBTX, USBRX); //Komunikacija s računalom
DigitalOut redLED(PA_9); //Izlaz crvene LED diode
DigitalOut yellowLED(PC_7); //Izlaz žute LED diode
DigitalOut greenLED(PB_6); //Izlaz zelene LED diode
PwmOut buzzer(PA_7); //Zvučnik
InterruptIn button1(PA_6); //Interrupt pin - tipkalo1
Ticker blink; //Ticker za blinkanje LED dioda
Timer debounce; //Timer za micanje debouncinga
void toggle(void); //Semafor u kvaru - zaustavlja se rad
int state=1;  // inicijalizacija varijable
int sec=0; // inicijalizacija varijable

float frequency[]={659.3, 659.3, 659.3, 587.3, 587.3, 523.3, 523.3, 392, 349.2, 329.6, 349.2,
392, 440, 392, 349.2, 329.6, 349.2, 392, 659.3, 659.3, 659.3, 587.3, 587.3, 523.3, 523.3, 392,
349.2, 329.6, 349.2, 392, 440, 493.9, 493.9, 587.3, 523.3, 493.9, 493.9, 493.9, 440, 493.9,
493.9, 523.3, 587.3, 493.9, 587.3, 587.3, 587.3, 587.3, 587.3, 523.3, 493.9, 440, 392, 659.3,
659.3, 659.3, 587.3, 587.3, 523.3, 523.3, 392, 349.2, 329.6, 349.2, 392, 440, 493.9, 493.9,
587.3, 523.3, 0};
//trajanje nota
float beat[]={1, 1, 1.5, 0.5, 0.5, 0.5, 1, 2, 0.5, 0.5, 0.5, 0.5, 2, 0.5, 0.5, 0.5, 0.5, 2, 1, 1, 1.5, 0.5,
0.5, 0.5, 1, 2, 0.5, 0.5, 0.5, 0.5, 2, 0.5, 0.5, 1, 2, 1, 1, 1.5, 0.5, 1, 0.5, 0.5, 1.5, 0.5, 0.5, 0.5, 0.5,
0.5, 1, 1, 1, 1, 2, 1, 1, 1.5, 0.5, 0.5, 0.5, 1, 2, 0.5, 0.5, 0.5, 0.5, 2, 0.5, 0.5, 1, 2, 0.5};

void yellowBlink()
{
    yellowLED=!yellowLED;
}
 void odbrojavanje() // Odbrojavanje vremenskog perioda do promjene signalizacije na semaforu
{
    while (sec>0 && state!=5) {
        Seg1 = SegConvert(sec); // Ispisivanje na 7.seg display
        wait_us (1000000);
        sec--;
    }
}
 void signalizacija(int red, int yellow, int green, int trajanje)  // Signalizacija semafora
{
    redLED = red;
    yellowLED = yellow;
    greenLED= green;
    sec = trajanje;
}
 
int main()
{
    debounce.start();
    SegInit(); // Pozivanje funkcije za inicijalizaciju 7 seg. displaya
    while (true) {
        button1.rise(&toggle); // Interrupt, Semafor trenutno ne radi svira himna
        if(state==1) { // Crveno svijetlo na semaforu
            pc.printf("Zaustavi se.\n");
            blink.detach();
            signalizacija(1,0,0,6);
            state=2;
        } else if(state==2) { // Prijelaz iz crvenog svijetla u žuto te u zeleno svijetlo
            pc.printf("Pripremi se za kretanje.\n");
            signalizacija(1,1,0,3);
            state=3;
        } else if(state==3) { // Zeleno svijetlo na semaforu
            pc.printf("Kreni.\n");
            signalizacija(0,0,1,9);
            state=4;
        } else if(state==4) { // Prijelaz iz zelenoga svijetla u žuto te u crveno svijetlo
            pc.printf("Priprema za crveno svijetlo.\n");
            signalizacija(0,1,0,3);
            state=1;
 
        } else  if(state==5) { // Semafor u kvaru
            pc.printf("Semafor u kvaru.\n");
            signalizacija(0,0,0,0);
            blink.attach(&yellowBlink, 0.75); // Ticker blinkanje LED žute
            state=6;
            Seg1 = SegConvert(10);
            for (int i=0; i<=70; i++) {
                buzzer.period(1/(frequency[i])); // postavljane PWM perioda
                buzzer=0.5; // set duty cycle
                wait(0.5*beat[i]);
                if (i==70){
                    state=4;
                }
            }
        }
        odbrojavanje();
    }
 
}
 
//Interrupt, Semafor u kvaru
void toggle()
{
    if (debounce.read_ms()>200) { // only allow toggle if debounce timer
        state=5; // has passed 200 ms
    }
    debounce.reset(); // restart timer when the toggle is performed

}
 

