//Kosntrukcijski_Grobenski_Semafor

#include "mbed.h"
#include "buzzer.h"

DigitalOut redled(A0); //pin A0 digitalni izlaz
DigitalOut yellowled(A1); //pin A1 digitalni izlaz
DigitalOut greenled(A2); //pin A2 digitalni izlaz
DigitalOut LED(LED2); //digitalni izlaz
Beep buzzer(D7);  //pin D7 za buzzer

float vrijeme = 1; //vrijeme
float fr1 = 850; //varijabla frekvencija zvuka 1
float fr2 = 350; //varijabla frekvencija zvuka 2

InterruptIn gumb(USER_BUTTON);

Ticker flipper;
Timer debounce;


void svjetljenje(void);
void toggle(void);

int main()
{
    while (1) {

        redled = 1;
        flipper.attach(&svjetljenje,0.5);
        debounce.start();
        gumb.rise(&toggle);

        if(LED==1) {

            redled = 1;
            greenled = 0;
            if(redled=1) {
                for (int i=0; i<=3; i++) {
                    buzzer.beep(fr1,vrijeme); //buzzer određen frekvencijom freq1 i vremenom
                    wait(vrijeme);
                }
            }

            wait(vrijeme);

            redled = 0;
            greenled = 1;

            if(greenled=1) {
                for (int i=0; i<=3; i++) {
                    buzzer.beep(fr2,vrijeme); //buzzer određen frekvencijom freq1 i vremenom
                    wait(vrijeme);
                }
            }

        } else {
            greenled=0;
            redled=1;
        }

    }

}
void svjetljenje(void) //titranje zute ledice
{
    yellowled=!yellowled;
}

void toggle()  //za debounce i mijenjanje stanja integrirane ledice
{
    if (debounce.read_ms()>200)
        LED=!LED;
    greenled=0;
    debounce.reset();
}