#include "mbed.h"

BusOut zaslon(D11,D10,D9,D8,D7,D12,D13);

DigitalOut crveno(D4);
DigitalOut zuto(D3);
DigitalOut zeleno(D2);
DigitalIn prekidac4(D14);
DigitalIn prekidac3(D15);

PwmOut zvucniSignal(A3);

InterruptIn promjenaNacinaRada(USER_BUTTON);
InterruptIn tipkaZaPjesakeNocniNacinRada(D5);

Timeout upaliCrveno;
Timeout upaliZuto;
Timeout upaliZeleno;
Timeout ugasiCrveno;
Timeout ugasiZuto;
Timeout ugasiZeleno;
Timeout ugasiZvuk;
Timeout promjenaZvukaZaPjesake;
Ticker upaliZvuk;
Ticker paliZaslon;
Ticker blinkZuto;

int i;
int nacinRada=3;
int zabraniPrvuSmjenuDnevnogNacina=0;
int zabraniDruguSmjenuDnevnogNacina=1;
int zabraniNocniRad=0;
int zabraniBlinkZuto=0;
int trenutniBrojNaZaslonu=0;
int smjenaDnevnogNacina=0;
int ponoviPetlju;
int zabraniPrekid=0;
int BR0=0x3F;
int BR1=0x06;
int BR2=0x5B;
int BR3=0x4F;
int BR4=0x66;
int BR5=0x6D;
int BR6=0x7D;
int BR7=0x07;
int BR8=0x7F;
int BR9=0x6F;

char brojevi[10] = {BR0, BR1, BR2, BR3, BR4, BR5, BR6, BR7, BR8,BR9};



void paliOdbrojavanjeNaZaslonu(){
    
    zaslon=brojevi[trenutniBrojNaZaslonu];
    
    if(trenutniBrojNaZaslonu==0){
        zaslon=0x0;
        paliZaslon.detach();
    
    }
    
    trenutniBrojNaZaslonu=trenutniBrojNaZaslonu-1;
    
}



void gasiZvuk(){
    
    zvucniSignal=0;
    
}



void paliZvuk(){
    
    zvucniSignal=0.5;
    ugasiZvuk.attach(&gasiZvuk,0.05);
    
}



void upaliCrvenoPjesacima(){
    
    upaliZvuk.detach();
    zvucniSignal.period(0.004);
    upaliZvuk.attach(&paliZvuk,1);
        
}



void upaliZelenoPjesacima(){ 
    
    upaliZvuk.detach();
    zvucniSignal.period(0.0004);
    upaliZvuk.attach(&paliZvuk,0.2);
    promjenaZvukaZaPjesake.detach();
    promjenaZvukaZaPjesake.attach(&upaliCrvenoPjesacima,6);
        
}



void UpaliCrvenoDnevniNacinRada(){      
    
    promjenaZvukaZaPjesake.attach(&upaliZelenoPjesacima,1);
    crveno=1;
    zabraniPrvuSmjenuDnevnogNacina=0;
    
}
    
    
    
void UpaliZutoDnevniNacinRada(){        
    
    zuto=1;
    
    if(smjenaDnevnogNacina==2){
        paliZaslon.attach(&paliOdbrojavanjeNaZaslonu,1);
   
    }
    
    
}
   
   
    
void UpaliZelenoDnevniNacinRada(){
    
    zeleno=1;
    zabraniDruguSmjenuDnevnogNacina=0;
    
}

  
    
void UgasiCrvenoDnevniNacinRada(){
    
    crveno=0;
    
}
 
 
    
void UgasiZutoDnevniNacinRada(){
    
    zuto=0;
    
}
   
   
    
void UgasiZelenoDnevniNacinRada(){
    
    zeleno=0;
    
}



void UpaliZutoNocniNacinRada(){
    
    zuto=1;
    
}



void UpaliZelenoNocniNacinRada(){
    
    zeleno=1;
    zabraniPrekid=0;
    
}

  
    
void UgasiCrvenoNocniNacinRada(){
    
    crveno=0;
    
}
 
 
    
void UgasiZutoNocniNacinRada(){
    
    zuto=0;
    
}
   
   
    
void UgasiZelenoNocniNacinRada(){
    
    zeleno=0;
    
}



void nastaviPrekidNocniNacinrada(){

    upaliZuto.attach(&UpaliZutoNocniNacinRada,8);
    ugasiZuto.attach(&UgasiZutoNocniNacinRada,9);
    ugasiCrveno.attach(&UgasiCrvenoNocniNacinRada,9);
    upaliZeleno.attach(&UpaliZelenoNocniNacinRada,9);
    
}



void UpaliCrvenoNocniNacinRada(){
    
    crveno=1;
    promjenaZvukaZaPjesake.attach(&upaliZelenoPjesacima,1);
    nastaviPrekidNocniNacinrada();
   
}



void ugasiBlinkZuto(){
    
    zuto=0;
    
}



void upaliBlinkZuto(){
   
   zuto=1;
   ugasiZuto.attach(&ugasiBlinkZuto,1);
    
}



void upaliZelenoZaPjesakeNocniNacinRada(){
    
    if(zabraniPrekid==0){
        
        if(nacinRada==1){
        
            zabraniPrekid=1;
            trenutniBrojNaZaslonu=6;
            paliZaslon.attach(&paliOdbrojavanjeNaZaslonu,1);
            ugasiZeleno.attach(&UgasiZelenoNocniNacinRada,5);
            upaliZuto.attach(&UpaliZutoNocniNacinRada,5);
            ugasiZuto.attach(&UgasiZutoNocniNacinRada,6);
            upaliCrveno.attach(&UpaliCrvenoNocniNacinRada,6);
                  
        }
        
    }
    
}
   
    
    
void dnevniNacinRada()
{
        
    if(zabraniPrvuSmjenuDnevnogNacina==0){
        smjenaDnevnogNacina=1;
        crveno=1;
        zuto=0;
        zeleno=0;
        upaliZuto.attach(&UpaliZutoDnevniNacinRada,8);
        ugasiCrveno.attach(&UgasiCrvenoDnevniNacinRada,9);
        ugasiZuto.attach(&UgasiZutoDnevniNacinRada,9);
        upaliZeleno.attach(&UpaliZelenoDnevniNacinRada,9);
        zabraniPrvuSmjenuDnevnogNacina=1;
        
    }
    
    if(zabraniDruguSmjenuDnevnogNacina==0){    
        smjenaDnevnogNacina=2;
        ugasiZeleno.attach(&UgasiZelenoDnevniNacinRada,6);
        upaliZuto.attach(&UpaliZutoDnevniNacinRada,6);
        ugasiZuto.attach(&UgasiZutoDnevniNacinRada,7);
        upaliCrveno.attach(&UpaliCrvenoDnevniNacinRada,7);
        trenutniBrojNaZaslonu=9;
        zabraniDruguSmjenuDnevnogNacina=1;
        
    }
    
}   
    


void nocniNacinRada(){
    
    if(zabraniNocniRad==0){
    
        crveno=0;
        zuto=0;
        zeleno=1;
        upaliCrvenoPjesacima();
        zabraniNocniRad=1;
   
   } 
   
}



void nacinRadaBlinkZuto(){
    
    if(zabraniBlinkZuto==0){
        crveno=0;
        zeleno=0;
        blinkZuto.attach(&upaliBlinkZuto,2);
        zabraniBlinkZuto=1;    
    
    }

}

    

void NacinRadaUgasen(){
    
    crveno=0;
    zuto=0;
    zeleno=0;
    zvucniSignal=0;
    
}



void promjeni(){

    upaliCrveno.detach();
    upaliZuto.detach();
    upaliZeleno.detach();
    ugasiCrveno.detach();
    ugasiZuto.detach();
    ugasiZeleno.detach();
    ugasiZvuk.detach();
    promjenaZvukaZaPjesake.detach();
    upaliZvuk.detach();
    paliZaslon.detach();
    blinkZuto.detach();
    
    zvucniSignal.period(0.0015);
    zvucniSignal=0.5;
    zaslon=0x0;
    

    crveno=1;
    zuto=1;
    zeleno=1;
    wait(1);
    crveno=0;
    zuto=0;
    zeleno=0;
    wait(1);
    crveno=1;
    zuto=1;
    zeleno=1;
    wait(1);
    crveno=0;
    zuto=0;
    zeleno=0;
    
    zvucniSignal=0;
    zvucniSignal.period(0.02);
    
    zabraniPrvuSmjenuDnevnogNacina=0;
    zabraniNocniRad=0;
    zabraniBlinkZuto=0;
    
    for(ponoviPetlju=10;ponoviPetlju>0;ponoviPetlju--){
        
        if((prekidac4==0) && (prekidac3==0)){
               
                nacinRada=0;
                
        }
        if((prekidac4==1) && (prekidac3==0)){
                
                nacinRada=1;
                
        }
        if((prekidac4==0) && (prekidac3==1)){
               
               
                nacinRada=2;
                
         }
        if((prekidac4==1) && (prekidac3==1)){
                
                nacinRada=3;
            
        }
        
    }
    
}  
    
    

int main(){
    
    promjenaNacinaRada.fall(&promjeni);
    tipkaZaPjesakeNocniNacinRada.rise(&upaliZelenoZaPjesakeNocniNacinRada);
    crveno=0;
    zuto=0;
    zeleno=0;
    zvucniSignal.period(0.0015);
    zvucniSignal=0.5;
    
    
    for(i=0;i<10;i++){
        
        crveno=1;
        wait(0.15);
        crveno=0;
        zuto=1;
        wait(0.15);
        zuto=0;
        zeleno=1;
        wait(0.15);
        zeleno=0;
        
    }
       
    zvucniSignal=0;
    
    while(1){  
     
        do{
            if(nacinRada==0){
                
                dnevniNacinRada();
                
            }
            
        }
        
        while(nacinRada==0);
    
        do{
            if(nacinRada==1){
                
                nocniNacinRada();
                
            }
            
        }
        
        while(nacinRada==1);
        
        do{
            if(nacinRada==2){
                
                nacinRadaBlinkZuto();
                
            }
            
        }
        
        while(nacinRada==2);

        do{
            if(nacinRada==3){
                
                NacinRadaUgasen();
            
            }
        
        }
        
        while(nacinRada==3);

    }
    
}